/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.notifications.internal.security;

import com.atlassian.fugue.Either;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.comments.Comment;
import com.atlassian.jira.issue.comments.CommentPermissionManager;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.api.commons.error.HttpStatusCode;
import com.atlassian.pocketknife.api.commons.jira.ErrorResultHelper;
import com.atlassian.pocketknife.step.Steps;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.api.ServiceDesk;
import com.atlassian.servicedesk.api.ServiceDeskService;
import com.atlassian.servicedesk.api.customer.CustomerContextService;
import com.atlassian.servicedesk.api.permission.ServiceDeskPermissionService;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.api.user.SDUser;
import com.atlassian.servicedesk.api.user.UserFactory;
import com.atlassian.servicedesk.internal.api.comment.ServiceDeskCommentPermissionService;
import com.atlassian.servicedesk.internal.api.customfields.origin.VpOriginCustomFieldService;
import com.atlassian.servicedesk.internal.api.feature.customer.request.CustomerRequestStatusManager;
import com.atlassian.servicedesk.internal.api.user.permission.ServiceDeskLicenseAndPermissionService;
import com.atlassian.servicedesk.plugins.notifications.internal.message.RecipientNotificationMessage;
import com.atlassian.servicedesk.plugins.notifications.internal.security.NotificationPermissionService;
import io.atlassian.fugue.Option;
import io.atlassian.fugue.Unit;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class NotificationPermissionServiceImpl
implements NotificationPermissionService {
    private final CustomerContextService customerContextService;
    private final ErrorResultHelper errorResultHelper;
    private final ProjectManager projectManager;
    private final ServiceDeskLicenseAndPermissionService serviceDeskLicenseAndPermissionService;
    private final ServiceDeskPermissionService serviceDeskPermissionService;
    private final ServiceDeskService serviceDeskService;
    private final UserFactory userFactory;
    private final VpOriginCustomFieldService vpOriginCustomFieldService;
    private final CommentPermissionManager commentPermissionManager;
    private final ServiceDeskCommentPermissionService serviceDeskCommentPermissionService;
    private final CustomerRequestStatusManager customerRequestStatusManager;

    @Autowired
    public NotificationPermissionServiceImpl(CustomerContextService customerContextService, ErrorResultHelper errorResultHelper, ProjectManager projectManager, ServiceDeskLicenseAndPermissionService serviceDeskLicenseAndPermissionService, ServiceDeskPermissionService serviceDeskPermissionService, ServiceDeskService serviceDeskService, UserFactory userFactory, VpOriginCustomFieldService vpOriginCustomFieldService, CommentPermissionManager commentPermissionManager, ServiceDeskCommentPermissionService serviceDeskCommentPermissionService, CustomerRequestStatusManager customerRequestStatusManager) {
        this.customerContextService = customerContextService;
        this.errorResultHelper = errorResultHelper;
        this.projectManager = projectManager;
        this.serviceDeskLicenseAndPermissionService = serviceDeskLicenseAndPermissionService;
        this.serviceDeskPermissionService = serviceDeskPermissionService;
        this.serviceDeskService = serviceDeskService;
        this.userFactory = userFactory;
        this.vpOriginCustomFieldService = vpOriginCustomFieldService;
        this.commentPermissionManager = commentPermissionManager;
        this.serviceDeskCommentPermissionService = serviceDeskCommentPermissionService;
        this.customerRequestStatusManager = customerRequestStatusManager;
    }

    @Override
    public io.atlassian.fugue.Either<AnError, Unit> checkProjectAdminPermission(ApplicationUser user, long projectId) {
        return this.retrieveServiceDesk(user, projectId).flatMap(serviceDesk -> StepsConverters.newerEither((Either)this.serviceDeskPermissionService.isAdminAgent(user, serviceDesk))).flatMap(isPermitted -> this.toPermissionResult(user, (Boolean)isPermitted));
    }

    private io.atlassian.fugue.Either<AnError, Unit> toPermissionResult(ApplicationUser user, Boolean isPermitted) {
        if (isPermitted.booleanValue()) {
            return io.atlassian.fugue.Either.right((Object)Unit.VALUE);
        }
        return io.atlassian.fugue.Either.left((Object)this.errorResultHelper.anError(user, HttpStatusCode.FORBIDDEN, "sd.notifications.base.user.missing.permission", new Object[0]));
    }

    private io.atlassian.fugue.Either<AnError, ServiceDesk> retrieveServiceDesk(ApplicationUser user, long projectId) {
        return this.retrieveProject(user, projectId).flatMap(project -> StepsConverters.newerEither((Either)this.serviceDeskService.getServiceDeskForProject(user, project)));
    }

    private io.atlassian.fugue.Either<AnError, Project> retrieveProject(ApplicationUser user, long projectId) {
        return Option.option((Object)this.projectManager.getProjectObj(Long.valueOf(projectId))).toRight(() -> this.errorResultHelper.anError(user, HttpStatusCode.BAD_REQUEST, "sd.notifications.base.project.missing", new Object[0]));
    }

    @Override
    public boolean isAllowedToReceiveMessage(RecipientNotificationMessage message) {
        return this.checkIssuePermission(message) && this.checkCommentPermission(message) && this.checkCustomerVisibleStatusChange(message);
    }

    private boolean checkCustomerVisibleStatusChange(RecipientNotificationMessage recipientNotificationMessage) {
        return (Boolean)Steps.begin(this.retrieveCustomerVisibleFromStatus(recipientNotificationMessage)).then(fromStatus -> this.retrieveCustomerVisibleToStatus(recipientNotificationMessage)).yield((fromStatus, toStatus) -> !Objects.equals(fromStatus, toStatus)).getOrElse((Object)true);
    }

    private Option<String> retrieveCustomerVisibleFromStatus(RecipientNotificationMessage message) {
        return message.getStatusChange().flatMap(statusChange -> this.retrieveCustomerVisibleStatus(message, statusChange.getFromStatus()));
    }

    private Option<String> retrieveCustomerVisibleToStatus(RecipientNotificationMessage message) {
        return message.getStatusChange().flatMap(statusChange -> this.retrieveCustomerVisibleStatus(message, statusChange.getToStatus()));
    }

    private Option<String> retrieveCustomerVisibleStatus(RecipientNotificationMessage message, String statusId) {
        return message.getIssue().flatMap(issue -> this.customerRequestStatusManager.retrieveCustomerVisibleStatus(message.getRecipient(), issue, statusId).toOption());
    }

    private boolean checkIssuePermission(RecipientNotificationMessage message) {
        return message.getIssue().isEmpty() || (Boolean)this.userFactory.wrap(message.getRecipient()).fold(error -> false, checkedUser -> this.checkIssuePermission((CheckedUser)checkedUser, (Issue)message.getIssue().get())) != false;
    }

    private boolean checkIssuePermission(CheckedUser user, Issue issue) {
        return this.checkRequestPermission(user, issue) || this.checkJiraIssuePermission(user, issue);
    }

    private boolean checkRequestPermission(CheckedUser user, Issue issue) {
        return this.isRequest(issue) && this.isCustomerOfProject(user, issue.getProjectObject()) && this.hasPermissionToViewRequestInCustomerPortal(user, issue);
    }

    private boolean isRequest(Issue issue) {
        CustomField cf = this.vpOriginCustomFieldService.getVpOriginCustomField();
        return issue.getCustomFieldValue(cf) != null;
    }

    private boolean isCustomerOfProject(CheckedUser user, Project project) {
        return (Boolean)this.customerContextService.runInCustomerContext(() -> this.serviceDeskLicenseAndPermissionService.canCreateRequest((SDUser)user, project));
    }

    private boolean hasPermissionToViewRequestInCustomerPortal(CheckedUser user, Issue issue) {
        return (Boolean)this.customerContextService.runInCustomerContext(() -> this.serviceDeskLicenseAndPermissionService.canViewRequestInPortal((SDUser)user, issue));
    }

    private boolean checkJiraIssuePermission(CheckedUser user, Issue issue) {
        return (Boolean)this.customerContextService.runOutOfCustomerContext(() -> this.serviceDeskLicenseAndPermissionService.canViewIssue((SDUser)user, issue));
    }

    private boolean checkCommentPermission(RecipientNotificationMessage message) {
        return message.getComment().isEmpty() || this.hasPermissionToViewComment(message.getRecipient(), (Comment)message.getComment().get());
    }

    private boolean hasPermissionToViewComment(ApplicationUser recipient, Comment comment) {
        return (Boolean)this.userFactory.wrap(recipient).fold(error -> false, checkedUser -> this.commentPermissionManager.hasBrowsePermission(recipient, comment) && (Boolean)this.customerContextService.runInCustomerContext(() -> this.serviceDeskCommentPermissionService.isSDCommentAndCanViewInPortal(checkedUser, comment)) != false);
    }
}

