/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.notifications.internal.scheduler;

import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.SchedulerService;
import com.atlassian.scheduler.SchedulerServiceException;
import com.atlassian.scheduler.config.JobConfig;
import com.atlassian.scheduler.config.JobId;
import com.atlassian.scheduler.config.JobRunnerKey;
import com.atlassian.scheduler.config.RunMode;
import com.atlassian.scheduler.config.Schedule;
import com.atlassian.servicedesk.plugins.notifications.internal.scheduler.NotificationBatchCleanUpJobRunner;
import com.atlassian.servicedesk.plugins.notifications.internal.scheduler.NotificationBatchJobRunner;
import java.util.Date;
import org.apache.commons.lang.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class NotificationBatchScheduler {
    private static final Logger LOG = LoggerFactory.getLogger(NotificationBatchScheduler.class);
    private static final long MINUTE_IN_MILLIS = 60000L;
    private static final JobRunnerKey SEND_JOB_RUNNER_KEY = JobRunnerKey.of((String)"sd.custom.notification.batch.job.runner");
    private static final JobRunnerKey CLEAN_UP_JOB_RUNNER_KEY = JobRunnerKey.of((String)"sd.custom.notification.clean.up.job.runner");
    private static final JobId BATCH_SENDING_JOB_ID = JobId.of((String)"sd.custom.notification.batch.send");
    private static final JobId BATCH_CLEAN_UP_JOB_ID = JobId.of((String)"sd.custom.notification.batch.clean.up");
    private final SchedulerService schedulerService;
    private final NotificationBatchCleanUpJobRunner notificationBatchCleanUpJobRunner;

    @Autowired
    public NotificationBatchScheduler(SchedulerService schedulerService, NotificationBatchCleanUpJobRunner notificationBatchCleanUpJobRunner) {
        this.schedulerService = schedulerService;
        this.notificationBatchCleanUpJobRunner = notificationBatchCleanUpJobRunner;
    }

    public void schedule() {
        this.scheduleBatchCleanUp();
    }

    public void scheduleBatchSending() {
        if (!this.isBatchSendingJobScheduled()) {
            LOG.info("Setting up notification batch sending schedule");
            JobConfig config = JobConfig.forJobRunnerKey((JobRunnerKey)SEND_JOB_RUNNER_KEY).withSchedule(Schedule.forInterval((long)60000L, (Date)this.retrieveFirstBatchSendingTime())).withRunMode(RunMode.RUN_ONCE_PER_CLUSTER);
            try {
                this.schedulerService.scheduleJob(BATCH_SENDING_JOB_ID, config);
                LOG.info("Successfully scheduled jobId={}", (Object)BATCH_SENDING_JOB_ID);
            }
            catch (SchedulerServiceException e) {
                LOG.error("Exception while setting up notification batch sending schedule", (Throwable)e);
            }
            LOG.info("Set up notification batch sending schedule");
        } else {
            LOG.debug("Notification batch sending job already defined. Skip scheduling.");
        }
    }

    private Date retrieveFirstBatchSendingTime() {
        return DateUtils.addMinutes((Date)new Date(), (int)1);
    }

    private boolean isBatchSendingJobScheduled() {
        return this.schedulerService.getJobDetails(BATCH_SENDING_JOB_ID) != null;
    }

    private void scheduleBatchCleanUp() {
        LOG.info("Setting up notification batch clean up schedule");
        JobConfig config = JobConfig.forJobRunnerKey((JobRunnerKey)CLEAN_UP_JOB_RUNNER_KEY).withSchedule(Schedule.forCronExpression((String)"0 0 1 ? * TUE")).withRunMode(RunMode.RUN_ONCE_PER_CLUSTER);
        try {
            this.schedulerService.scheduleJob(BATCH_CLEAN_UP_JOB_ID, config);
            LOG.info("Successfully scheduled jobId={}", (Object)BATCH_CLEAN_UP_JOB_ID);
        }
        catch (SchedulerServiceException e) {
            LOG.error("Exception while setting up notification batch clean up schedule", (Throwable)e);
        }
        LOG.info("Set up notification batch clean up schedule");
    }

    public void unschedule() {
        this.unscheduleBatchCleanUp();
    }

    void unscheduleBatchSending() {
        LOG.info("Tearing down notification batch sending schedule");
        this.schedulerService.unscheduleJob(BATCH_SENDING_JOB_ID);
        LOG.info("Successfully unscheduled jobId={}", (Object)BATCH_SENDING_JOB_ID);
    }

    private void unscheduleBatchCleanUp() {
        LOG.info("Tearing down notification batch clean up schedule");
        this.schedulerService.unscheduleJob(BATCH_CLEAN_UP_JOB_ID);
        LOG.info("Successfully unscheduled jobId={}", (Object)BATCH_CLEAN_UP_JOB_ID);
    }

    public void register(NotificationBatchJobRunner notificationBatchJobRunner) {
        LOG.info("Registering SEND, CLEANUP JobRunner");
        this.schedulerService.registerJobRunner(CLEAN_UP_JOB_RUNNER_KEY, (JobRunner)this.notificationBatchCleanUpJobRunner);
        this.schedulerService.registerJobRunner(SEND_JOB_RUNNER_KEY, (JobRunner)notificationBatchJobRunner);
    }

    public void unregister() {
        LOG.info("Unregistering SEND, CLEANUP JobRunner");
        this.schedulerService.unregisterJobRunner(SEND_JOB_RUNNER_KEY);
        this.schedulerService.unregisterJobRunner(CLEAN_UP_JOB_RUNNER_KEY);
    }
}

