/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.notifications.internal.rest;

import com.atlassian.fugue.Either;
import com.atlassian.jira.bc.project.ProjectService;
import com.atlassian.jira.project.Project;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.api.commons.jira.ErrorResultHelper;
import com.atlassian.pocketknife.step.Steps;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.api.user.UserFactory;
import com.atlassian.servicedesk.internal.api.ServiceDeskManager;
import com.atlassian.servicedesk.internal.api.rest.RestResponseHelper;
import com.atlassian.servicedesk.plugins.notifications.internal.preview.StylingPreviewData;
import com.atlassian.servicedesk.plugins.notifications.internal.preview.StylingPreviewService;
import com.atlassian.servicedesk.plugins.notifications.internal.rest.request.StylingPreviewRequest;
import com.atlassian.servicedesk.plugins.notifications.internal.rest.response.NotificationPreviewResponse;
import com.atlassian.servicedesk.plugins.notifications.internal.rest.response.SendPreviewEmailResponse;
import java.util.Locale;
import java.util.Objects;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Path(value="styling-preview")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class StylingPreviewResource {
    private static final String UNDETERMINED_LANGUAGE_TAG = "und";
    private final RestResponseHelper restResponseHelper;
    private final UserFactory userFactory;
    private final ProjectService projectService;
    private final ServiceDeskManager serviceDeskManager;
    private final ErrorResultHelper errorResultHelper;
    private final StylingPreviewService stylingPreviewService;

    public StylingPreviewResource(RestResponseHelper restResponseHelper, UserFactory userFactory, ProjectService projectService, ServiceDeskManager serviceDeskManager, ErrorResultHelper errorResultHelper, StylingPreviewService stylingPreviewService) {
        this.restResponseHelper = restResponseHelper;
        this.userFactory = userFactory;
        this.projectService = projectService;
        this.serviceDeskManager = serviceDeskManager;
        this.errorResultHelper = errorResultHelper;
        this.stylingPreviewService = stylingPreviewService;
    }

    @POST
    public Response renderPreview(StylingPreviewRequest request) {
        io.atlassian.fugue.Either previewEither = Steps.begin((io.atlassian.fugue.Either)StepsConverters.newerEither((Either)this.userFactory.getCheckedUser())).then(user -> this.retrieveProjectForUser((CheckedUser)user, request.getProjectKey())).then((user, project) -> this.serviceDeskManager.getServiceDeskForProject(project)).then((user, project, serviceDesk) -> this.getLocale(request)).then((user, project, serviceDesk, locale) -> this.stylingPreviewService.renderPreview(this.createPreviewData(request, (CheckedUser)user, (Project)project, (Locale)locale))).yield((user, project, serviceDesk, locale, preview) -> new NotificationPreviewResponse((String)preview));
        return this.restResponseHelper.anErrorEitherToOkResponse(previewEither);
    }

    @POST
    @Path(value="send-email")
    public Response sendTestEmail(StylingPreviewRequest request) {
        io.atlassian.fugue.Either result = Steps.begin((io.atlassian.fugue.Either)StepsConverters.newerEither((Either)this.userFactory.getCheckedUser())).then(user -> this.retrieveProjectForUser((CheckedUser)user, request.getProjectKey())).then((user, project) -> this.serviceDeskManager.getServiceDeskForProject(project)).then((user, project, serviceDesk) -> this.getLocale(request)).then((user, project, servicedesk, locale) -> this.stylingPreviewService.sendTestEmail(this.createPreviewData(request, (CheckedUser)user, (Project)project, (Locale)locale))).yield((user, project, servicedesk, locale, toAddress) -> new SendPreviewEmailResponse((String)toAddress));
        return this.restResponseHelper.anErrorEitherToOkResponse(result);
    }

    private io.atlassian.fugue.Either<AnError, Project> retrieveProjectForUser(CheckedUser user, String projectKey) {
        ProjectService.GetProjectResult getProjectResult = this.projectService.getProjectByKey(user.forJIRA(), projectKey);
        if (!getProjectResult.isValid()) {
            return io.atlassian.fugue.Either.left((Object)this.errorResultHelper.notFound404("sd.error.project.not.found", new Object[]{projectKey}).build());
        }
        return io.atlassian.fugue.Either.right((Object)getProjectResult.getProject());
    }

    private io.atlassian.fugue.Either<AnError, Locale> getLocale(StylingPreviewRequest stylingPreviewRequest) {
        Locale locale = Locale.forLanguageTag(stylingPreviewRequest.getLanguageTag());
        if (Objects.equals(locale.toLanguageTag(), UNDETERMINED_LANGUAGE_TAG)) {
            return io.atlassian.fugue.Either.left((Object)this.errorResultHelper.badRequest400("sd.notifications.preview.validation.locale.invalid", new Object[]{stylingPreviewRequest.getLanguageTag()}).build());
        }
        return io.atlassian.fugue.Either.right((Object)locale);
    }

    private StylingPreviewData createPreviewData(StylingPreviewRequest request, CheckedUser user, Project project, Locale locale) {
        return new StylingPreviewData(user, request.getSubjectTemplate(), request.getHtmlTemplate(), request.getTextTemplate(), request.getCss(), project, locale, request.isRenderHtml());
    }
}

