/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.notifications.internal.rest;

import com.atlassian.fugue.Either;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.api.commons.error.HttpStatusCode;
import com.atlassian.pocketknife.api.commons.jira.ErrorResultHelper;
import com.atlassian.pocketknife.step.Steps;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.api.user.UserFactory;
import com.atlassian.servicedesk.internal.api.rest.RestResponseHelper;
import com.atlassian.servicedesk.plugins.notifications.internal.configuration.NotificationRecipientType;
import com.atlassian.servicedesk.plugins.notifications.internal.recipients.RecipientConfigurationService;
import com.atlassian.servicedesk.plugins.notifications.internal.rest.SendActionConfigurationResourceHelper;
import com.atlassian.servicedesk.plugins.notifications.internal.rest.response.VariableGroup;
import com.atlassian.servicedesk.plugins.notifications.internal.variables.configuration.AvailableVariableService;
import io.atlassian.fugue.Eithers;
import io.atlassian.fugue.Option;
import java.util.List;
import java.util.Set;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;

@Path(value="/configuration/{projectId}")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class SendActionConfigurationResource {
    private final ErrorResultHelper errorResultHelper;
    private final RecipientConfigurationService recipientConfigurationService;
    private final AvailableVariableService availableVariableService;
    private final RestResponseHelper restResponseHelper;
    private final UserFactory userFactory;
    private final SendActionConfigurationResourceHelper helper;

    protected SendActionConfigurationResource(ErrorResultHelper errorResultHelper, RecipientConfigurationService recipientConfigurationService, AvailableVariableService availableVariableService, RestResponseHelper restResponseHelper, UserFactory userFactory, SendActionConfigurationResourceHelper helper) {
        this.errorResultHelper = errorResultHelper;
        this.recipientConfigurationService = recipientConfigurationService;
        this.availableVariableService = availableVariableService;
        this.restResponseHelper = restResponseHelper;
        this.userFactory = userFactory;
        this.helper = helper;
    }

    @GET
    public Response retrieveConfigurationChoices(@PathParam(value="projectId") Long projectId, @QueryParam(value="lingoId") Long lingoId) {
        if (projectId == null) {
            return this.restResponseHelper.anErrorToResponse(this.errorResultHelper.anError(HttpStatusCode.BAD_REQUEST, "sd.notifications.base.project.missing", new Object[0]));
        }
        Option lingoIdOpt = Option.option((Object)lingoId);
        io.atlassian.fugue.Either result = Steps.begin(this.getLoggedinUser()).then(user -> this.recipientConfigurationService.retrieveAvailableRecipientsTypes(user.forJIRA(), projectId)).then((user, recipients) -> this.availableVariableService.retrieveAvailableContentVariableGroups(user.forJIRA(), projectId)).yield((user, recipients, variables) -> this.helper.buildConfigResponse((CheckedUser)user, projectId, (Set<NotificationRecipientType>)recipients, (List<VariableGroup>)variables, (Option<Long>)lingoIdOpt));
        return (Response)Eithers.merge((io.atlassian.fugue.Either)result.leftMap(arg_0 -> ((RestResponseHelper)this.restResponseHelper).anErrorToResponse(arg_0)));
    }

    private io.atlassian.fugue.Either<AnError, CheckedUser> getLoggedinUser() {
        return StepsConverters.newerEither((Either)this.userFactory.getCheckedUser()).leftMap(error -> this.errorResultHelper.anError(HttpStatusCode.UNAUTHORIZED, "sd.notifications.base.user.not.logged.in", new Object[0]));
    }
}

