/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.notifications.internal.rest;

import com.atlassian.fugue.Either;
import com.atlassian.jira.bc.project.ProjectService;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.api.commons.jira.ErrorResultHelper;
import com.atlassian.pocketknife.step.Steps;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.api.ServiceDesk;
import com.atlassian.servicedesk.api.ServiceDeskService;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.api.user.UserFactory;
import com.atlassian.servicedesk.internal.api.lingo.project.LingoProjectConfiguration;
import com.atlassian.servicedesk.internal.api.lingo.project.LingoProjectLanguageManager;
import com.atlassian.servicedesk.internal.api.notifications.ServiceDeskNotificationSender;
import com.atlassian.servicedesk.internal.api.rest.RestResponseHelper;
import com.atlassian.servicedesk.plugins.notifications.internal.bootstrap.featureflag.SDNotificationsFeatureFlags;
import com.atlassian.servicedesk.plugins.notifications.internal.bootstrap.upgrade.task.NotificationDefaultRuleDefaults;
import com.atlassian.servicedesk.plugins.notifications.internal.outgoingemail.settings.OutgoingEmailDefaultCssLoader;
import com.atlassian.servicedesk.plugins.notifications.internal.outgoingemail.settings.OutgoingEmailDefaultHtmlTemplateProvider;
import com.atlassian.servicedesk.plugins.notifications.internal.outgoingemail.settings.OutgoingEmailDefaultPlainTextTemplateProvider;
import com.atlassian.servicedesk.plugins.notifications.internal.outgoingemail.settings.OutgoingEmailSettingsModel;
import com.atlassian.servicedesk.plugins.notifications.internal.outgoingemail.settings.OutgoingEmailSettingsService;
import com.atlassian.servicedesk.plugins.notifications.internal.outgoingemail.settings.request.OutgoingEmailSettingsInput;
import com.atlassian.servicedesk.plugins.notifications.internal.outgoingemail.settings.validation.ValidationFailure;
import com.atlassian.servicedesk.plugins.notifications.internal.rest.NotificationResourceHelper;
import com.atlassian.servicedesk.plugins.notifications.internal.rest.request.UpdateProjectTemplateRequest;
import com.atlassian.servicedesk.plugins.notifications.internal.rest.response.AvailableLanguageResponse;
import com.atlassian.servicedesk.plugins.notifications.internal.rest.response.OutgoingEmailRuleListResponse;
import com.atlassian.servicedesk.plugins.notifications.internal.rest.response.OutgoingEmailRuleResponse;
import com.atlassian.servicedesk.plugins.notifications.internal.rest.response.OutgoingEmailSettingsResponse;
import com.atlassian.servicedesk.plugins.notifications.internal.simpleui.rule.NotificationErrorHelper;
import com.atlassian.servicedesk.plugins.notifications.internal.simpleui.rule.NotificationRule;
import com.atlassian.servicedesk.plugins.notifications.internal.simpleui.rule.NotificationRuleService;
import com.atlassian.servicedesk.plugins.notifications.internal.subject.EmailSubjectManager;
import com.atlassian.servicedesk.plugins.notifications.internal.variables.configuration.AvailableVariableService;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Path(value="outgoing-email-settings/{projectId}")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class OutgoingEmailSettingsResource {
    private final ErrorResultHelper errorResultHelper;
    private final UserFactory userFactory;
    private final ProjectService projectService;
    private final ServiceDeskService serviceDeskService;
    private final OutgoingEmailSettingsService outgoingEmailSettingsService;
    private final FeatureManager featureManager;
    private final RestResponseHelper restResponseHelper;
    private final NotificationRuleService notificationRuleService;
    private final EmailSubjectManager emailSubjectManager;
    private final NotificationDefaultRuleDefaults notificationDefaultRuleDefaults;
    private final LingoProjectLanguageManager lingoProjectLanguageManager;
    private final AvailableVariableService availableStylingVariables;
    private final OutgoingEmailDefaultHtmlTemplateProvider defaultHtmlTemplateProvider;
    private final OutgoingEmailDefaultPlainTextTemplateProvider defaultPlainTextTemplateProvider;
    private final OutgoingEmailDefaultCssLoader defaultCssLoader;
    private final NotificationErrorHelper notificationErrorHelper;
    private final NotificationResourceHelper notificationResourceHelper;
    private final ServiceDeskNotificationSender serviceDeskNotificationSender;

    public OutgoingEmailSettingsResource(ErrorResultHelper errorResultHelper, UserFactory userFactory, ProjectService projectService, ServiceDeskService serviceDeskService, OutgoingEmailSettingsService outgoingEmailSettingsService, FeatureManager featureManager, RestResponseHelper restResponseHelper, NotificationRuleService notificationRuleService, EmailSubjectManager emailSubjectManager, NotificationDefaultRuleDefaults notificationDefaultRuleDefaults, LingoProjectLanguageManager lingoProjectLanguageManager, AvailableVariableService availableStylingVariables, OutgoingEmailDefaultHtmlTemplateProvider defaultHtmlTemplateProvider, OutgoingEmailDefaultPlainTextTemplateProvider defaultPlainTextTemplateProvider, OutgoingEmailDefaultCssLoader defaultCssLoader, NotificationErrorHelper notificationErrorHelper, NotificationResourceHelper notificationResourceHelper, ServiceDeskNotificationSender serviceDeskNotificationSender) {
        this.errorResultHelper = errorResultHelper;
        this.userFactory = userFactory;
        this.projectService = projectService;
        this.serviceDeskService = serviceDeskService;
        this.outgoingEmailSettingsService = outgoingEmailSettingsService;
        this.featureManager = featureManager;
        this.restResponseHelper = restResponseHelper;
        this.notificationRuleService = notificationRuleService;
        this.emailSubjectManager = emailSubjectManager;
        this.notificationDefaultRuleDefaults = notificationDefaultRuleDefaults;
        this.lingoProjectLanguageManager = lingoProjectLanguageManager;
        this.availableStylingVariables = availableStylingVariables;
        this.defaultHtmlTemplateProvider = defaultHtmlTemplateProvider;
        this.defaultPlainTextTemplateProvider = defaultPlainTextTemplateProvider;
        this.notificationErrorHelper = notificationErrorHelper;
        this.defaultCssLoader = defaultCssLoader;
        this.notificationResourceHelper = notificationResourceHelper;
        this.serviceDeskNotificationSender = serviceDeskNotificationSender;
    }

    @GET
    public Response getSettings(@PathParam(value="projectId") long projectId) {
        if (!this.featureManager.isEnabled(SDNotificationsFeatureFlags.NOTIFICATION_CUT_OVER)) {
            return this.featureNotEnabledResponse();
        }
        io.atlassian.fugue.Either settingsEither = Steps.begin((io.atlassian.fugue.Either)StepsConverters.newerEither((Either)this.userFactory.getCheckedUser())).then(user -> this.retrieveServiceDeskForProjectId((CheckedUser)user, projectId)).then(this.outgoingEmailSettingsService::retrieveSettings).yield((user, serviceDesk, settings) -> settings);
        return (Response)settingsEither.fold(arg_0 -> ((RestResponseHelper)this.restResponseHelper).anErrorToResponse(arg_0), settings -> this.buildSettingsResponse((OutgoingEmailSettingsModel)settings, projectId));
    }

    @GET
    @Path(value="rules")
    public Response getSystemRules(@PathParam(value="projectId") long projectId) {
        io.atlassian.fugue.Either systemRulesEither = Steps.begin((io.atlassian.fugue.Either)StepsConverters.newerEither((Either)this.userFactory.getCheckedUser())).then(user -> this.retrieveProjectForUser(user.forJIRA(), projectId)).then((user, project) -> this.notificationRuleService.getNotificationRules(user.forJIRA(), (Project)project)).yield((user, project, notificationRules) -> notificationRules);
        return (Response)systemRulesEither.fold(arg_0 -> ((RestResponseHelper)this.restResponseHelper).anErrorToResponse(arg_0), this::toRuleResponse);
    }

    @POST
    @Path(value="project-template")
    public Response updateProjectTemplate(@PathParam(value="projectId") long projectId, UpdateProjectTemplateRequest request) {
        if (!this.featureManager.isEnabled(SDNotificationsFeatureFlags.NOTIFICATION_CUT_OVER)) {
            return this.featureNotEnabledResponse();
        }
        io.atlassian.fugue.Either updatedSettingsEither = Steps.begin((io.atlassian.fugue.Either)StepsConverters.newerEither((Either)this.userFactory.getCheckedUser())).then(user -> this.retrieveServiceDeskForProjectId((CheckedUser)user, projectId)).then((user, serviceDesk) -> this.updateSettings((CheckedUser)user, (ServiceDesk)serviceDesk, request)).yield((user, serviceDesk, settings) -> settings);
        return (Response)updatedSettingsEither.fold(this.notificationErrorHelper::toResponse, updateResult -> (Response)updateResult.fold(this.notificationErrorHelper::toResponse, updatedSettings -> this.buildSettingsResponse((OutgoingEmailSettingsModel)updatedSettings, projectId)));
    }

    private io.atlassian.fugue.Either<AnError, io.atlassian.fugue.Either<ValidationFailure, OutgoingEmailSettingsModel>> updateSettings(CheckedUser user, ServiceDesk serviceDesk, UpdateProjectTemplateRequest request) {
        OutgoingEmailSettingsInput.Builder builder = OutgoingEmailSettingsInput.newBuilder();
        request.getEmailSubject().forEach(subject -> builder.emailSubject(this.languageTagKeysToLocales((Map<String, String>)subject)));
        if (this.featureManager.isEnabled("sd.custom.email.notifications.styling")) {
            request.getHtmlTemplate().forEach(template -> builder.htmlTemplate(this.languageTagKeysToLocales((Map<String, String>)template)));
            request.getCss().forEach(css -> builder.css(this.languageTagKeysToLocales((Map<String, String>)css)));
            request.getPlainTextTemplate().forEach(template -> builder.plainTextTemplate(this.languageTagKeysToLocales((Map<String, String>)template)));
        }
        return this.outgoingEmailSettingsService.updateSettings(user, serviceDesk, builder.build());
    }

    private Map<Locale, String> languageTagKeysToLocales(Map<String, String> translations) {
        return translations.entrySet().stream().collect(Collectors.toMap(entry -> Locale.forLanguageTag((String)entry.getKey()), Map.Entry::getValue));
    }

    private Response featureNotEnabledResponse() {
        return Response.status((int)412).build();
    }

    private io.atlassian.fugue.Either<AnError, ServiceDesk> retrieveServiceDeskForProjectId(CheckedUser user, long projectId) {
        ApplicationUser appUser = user.forJIRA();
        return this.retrieveProjectForUser(appUser, projectId).flatMap(project -> StepsConverters.newerEither((Either)this.serviceDeskService.getServiceDeskForProject(appUser, project)));
    }

    private Response buildSettingsResponse(OutgoingEmailSettingsModel model, long projectId) {
        LingoProjectConfiguration lingoConfiguration = this.lingoProjectLanguageManager.retrieveLingoProjectConfiguration(projectId);
        List<AvailableLanguageResponse> languages = this.notificationResourceHelper.transformAvailableLanguages(lingoConfiguration);
        String defaultSubject = this.emailSubjectManager.getDefaultRequestEmailSubject();
        Map<String, String> emailSubject = this.notificationResourceHelper.transformTranslationMap(model.getSubject());
        Map<String, String> htmlTemplate = this.notificationResourceHelper.transformTranslationMap(model.getHtmlTemplate());
        Map<String, String> css = this.notificationResourceHelper.transformTranslationMap(model.getCss());
        Map<String, String> plainTextTemplate = this.notificationResourceHelper.transformTranslationMap(model.getPlainTextTemplate());
        List availableVariables = (List)StepsConverters.newerEither((Either)this.userFactory.getCheckedUser()).flatMap(user -> this.availableStylingVariables.retrieveAvailableStylingVariableGroups(user.forJIRA(), projectId)).getOrElse(Collections.emptyList());
        OutgoingEmailSettingsResponse responseEntity = new OutgoingEmailSettingsResponse(emailSubject, defaultSubject, this.emailSubjectManager.getVariablesForEmailSubject(), languages, lingoConfiguration.getProjectDefaultLocale().toLanguageTag(), htmlTemplate, this.getDefaultHtmlTemplate(model), css, this.defaultCssLoader.getDefaultCss(), plainTextTemplate, this.getDefaultPlainTextTemplate(model), availableVariables);
        return this.restResponseHelper.ok((Object)responseEntity);
    }

    private Map<String, String> getDefaultHtmlTemplate(OutgoingEmailSettingsModel model) {
        return model.getHtmlTemplate().entrySet().stream().collect(Collectors.toMap(entry -> ((Locale)entry.getKey()).toLanguageTag(), entry -> this.defaultHtmlTemplateProvider.getDefaultTemplate((Locale)entry.getKey(), model.getServiceDesk())));
    }

    private Map<String, String> getDefaultPlainTextTemplate(OutgoingEmailSettingsModel model) {
        return model.getHtmlTemplate().entrySet().stream().collect(Collectors.toMap(entry -> ((Locale)entry.getKey()).toLanguageTag(), entry -> this.defaultPlainTextTemplateProvider.getDefaultTemplate((Locale)entry.getKey(), model.getServiceDesk())));
    }

    private Response toRuleResponse(List<NotificationRule> notificationRules) {
        List<OutgoingEmailRuleResponse> outgoingEmailRuleResponses = notificationRules.stream().map(outgoingEmailSystemRule -> new OutgoingEmailRuleResponse(outgoingEmailSystemRule.getRuleSetName(), outgoingEmailSystemRule.getRuleSetDescription(), outgoingEmailSystemRule.isRuleSetEnabled(), outgoingEmailSystemRule.isSystemRule(), outgoingEmailSystemRule.getRuleSetId(), this.notificationDefaultRuleDefaults.getAnalyticsSuffixFromI18nName(outgoingEmailSystemRule.getRuleSetI8nName()))).collect(Collectors.toList());
        return Response.ok((Object)new OutgoingEmailRuleListResponse(this.isOutgoingEmailConfigured(), outgoingEmailRuleResponses)).build();
    }

    private boolean isOutgoingEmailConfigured() {
        return this.serviceDeskNotificationSender.isOutgoingMailConfigured();
    }

    private io.atlassian.fugue.Either<AnError, Project> retrieveProjectForUser(ApplicationUser applicationUser, long projectId) {
        ProjectService.GetProjectResult getProjectResult = this.projectService.getProjectById(applicationUser, Long.valueOf(projectId));
        if (!getProjectResult.isValid()) {
            return io.atlassian.fugue.Either.left((Object)this.errorResultHelper.notFound404("sd.error.project.not.found", new Object[]{projectId}).build());
        }
        return io.atlassian.fugue.Either.right((Object)getProjectResult.getProject());
    }
}

