/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.notifications.internal.rest;

import com.atlassian.fugue.Either;
import com.atlassian.jira.bc.project.ProjectService;
import com.atlassian.jira.project.Project;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.api.commons.jira.ErrorResultHelper;
import com.atlassian.pocketknife.step.Steps;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.api.ServiceDesk;
import com.atlassian.servicedesk.api.ServiceDeskService;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.api.user.UserFactory;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.RuleSet;
import com.atlassian.servicedesk.plugins.notifications.internal.rest.request.NotificationRuleRequest;
import com.atlassian.servicedesk.plugins.notifications.internal.rest.response.NotificationRuleResponse;
import com.atlassian.servicedesk.plugins.notifications.internal.simpleui.rule.NotificationErrorHelper;
import com.atlassian.servicedesk.plugins.notifications.internal.simpleui.rule.NotificationRule;
import com.atlassian.servicedesk.plugins.notifications.internal.simpleui.rule.NotificationRuleError;
import com.atlassian.servicedesk.plugins.notifications.internal.simpleui.rule.NotificationRuleInput;
import com.atlassian.servicedesk.plugins.notifications.internal.simpleui.rule.NotificationRuleService;
import io.atlassian.fugue.Eithers;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Path(value="/rule/{projectKey}")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class NotificationRuleResource {
    private final ErrorResultHelper errorResultHelper;
    private final NotificationRuleService notificationRuleService;
    private final ProjectService projectService;
    private final UserFactory userFactory;
    private final ServiceDeskService serviceDeskService;
    private final NotificationErrorHelper notificationErrorHelper;

    public NotificationRuleResource(ErrorResultHelper errorResultHelper, NotificationRuleService notificationRuleService, ProjectService projectService, UserFactory userFactory, ServiceDeskService serviceDeskService, NotificationErrorHelper notificationErrorHelper) {
        this.errorResultHelper = errorResultHelper;
        this.notificationRuleService = notificationRuleService;
        this.projectService = projectService;
        this.userFactory = userFactory;
        this.serviceDeskService = serviceDeskService;
        this.notificationErrorHelper = notificationErrorHelper;
    }

    @GET
    @Path(value="/ruleset/{ruleSetId}")
    public Response getRuleConfiguration(@PathParam(value="projectKey") String projectKey, @PathParam(value="ruleSetId") Long ruleSetId) {
        return (Response)Steps.begin(this.getCheckedUser()).then(user -> this.getProject((CheckedUser)user, projectKey)).then((user, project) -> this.getServiceDesk((CheckedUser)user, (Project)project)).then((user, project, sd) -> this.getRuleConfiguration((CheckedUser)user, (ServiceDesk)sd, ruleSetId)).yield((user, project, sd, trigger) -> trigger).fold(this.notificationErrorHelper::toResponse, this::okResponse);
    }

    @PUT
    @Path(value="/ruleset/{ruleSetId}")
    public Response putRuleConfiguration(@PathParam(value="projectKey") String projectKey, @PathParam(value="ruleSetId") Long ruleSetId, NotificationRuleRequest request) {
        return (Response)Steps.begin(this.getCheckedUser()).then(user -> this.getProject((CheckedUser)user, projectKey)).then((user, project) -> this.getServiceDesk((CheckedUser)user, (Project)project)).then((user, project, sd) -> this.requestToNotificationRule(ruleSetId, request)).then((user, project, sd, notificationRuleInput) -> this.updateRuleConfiguration((CheckedUser)user, (ServiceDesk)sd, ruleSetId, (NotificationRuleInput)notificationRuleInput)).yield((user, project, sd, notificationRule, updatedRuleSet) -> updatedRuleSet).fold(this.notificationErrorHelper::toResponse, project -> Response.noContent().build());
    }

    private io.atlassian.fugue.Either<NotificationRuleError, NotificationRuleInput> requestToNotificationRule(long ruleSetId, NotificationRuleRequest request) {
        return Steps.begin(this.getConfiguration(request)).then(configuration -> this.getRuleEnabled(request)).yield((configuration, enabled) -> new NotificationRuleInput(ruleSetId, (Map<String, String>)configuration, (boolean)enabled)).leftMap(this.notificationErrorHelper::toNotificationRuleError);
    }

    private io.atlassian.fugue.Either<AnError, Map<String, String>> getConfiguration(NotificationRuleRequest notificationRuleRequest) {
        return notificationRuleRequest.getConfigurationData().toRight(() -> this.errorResultHelper.badRequest400("sd.notifications.rule.request.parameter.missing", new Object[]{"configurationData"}).build());
    }

    private io.atlassian.fugue.Either<AnError, Boolean> getRuleEnabled(NotificationRuleRequest notificationRuleRequest) {
        return notificationRuleRequest.getRuleEnabled().toRight(() -> this.errorResultHelper.badRequest400("sd.notifications.rule.request.parameter.missing", new Object[]{"ruleEnabled"}).build());
    }

    private NotificationRuleResponse toResponse(NotificationRule notificationRule) {
        return new NotificationRuleResponse(notificationRule.getRuleSetId(), notificationRule.getRuleSetName(), notificationRule.getRuleSetDescription(), notificationRule.getThenConfigurationData(), notificationRule.isRuleSetEnabled(), notificationRule.getProvides());
    }

    private Response okResponse(NotificationRule responseData) {
        return Response.ok((Object)this.toResponse(responseData)).build();
    }

    private io.atlassian.fugue.Either<NotificationRuleError, NotificationRule> getRuleConfiguration(CheckedUser user, ServiceDesk serviceDesk, Long ruleSetId) {
        return this.notificationRuleService.getRuleConfiguration(user, serviceDesk, ruleSetId);
    }

    private io.atlassian.fugue.Either<NotificationRuleError, RuleSet> updateRuleConfiguration(CheckedUser user, ServiceDesk serviceDesk, Long ruleSetId, NotificationRuleInput notificationRuleInput) {
        return this.notificationRuleService.updateRuleConfiguration(user, serviceDesk, ruleSetId, notificationRuleInput);
    }

    private io.atlassian.fugue.Either<NotificationRuleError, ServiceDesk> getServiceDesk(CheckedUser user, Project project) {
        return StepsConverters.newerEither((Either)this.serviceDeskService.getServiceDeskForProject(user.forJIRA(), project)).leftMap(this.notificationErrorHelper::toNotificationRuleError);
    }

    private io.atlassian.fugue.Either<NotificationRuleError, Project> getProject(CheckedUser user, String projectKey) {
        ProjectService.GetProjectResult result = this.projectService.getProjectByKey(user.forJIRA(), projectKey);
        return Eithers.cond((boolean)result.isValid(), (Object)this.errorResultHelper.notFound404("sd.notifications.base.project.missing", new Object[0]).build(), (Object)result.getProject()).leftMap(this.notificationErrorHelper::toNotificationRuleError);
    }

    private io.atlassian.fugue.Either<NotificationRuleError, CheckedUser> getCheckedUser() {
        return StepsConverters.newerEither((Either)this.userFactory.getCheckedUser()).leftMap(this.notificationErrorHelper::toNotificationRuleError);
    }
}

