/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.notifications.internal.rest;

import com.atlassian.servicedesk.internal.api.lingo.project.LingoProjectConfiguration;
import com.atlassian.servicedesk.internal.api.lingo.project.LingoProjectLanguageManager;
import com.atlassian.servicedesk.plugins.notifications.internal.rest.response.AvailableLanguageResponse;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
class NotificationResourceHelper {
    private final LingoProjectLanguageManager lingoProjectLanguageManager;

    @Autowired
    NotificationResourceHelper(LingoProjectLanguageManager lingoProjectLanguageManager) {
        this.lingoProjectLanguageManager = lingoProjectLanguageManager;
    }

    List<AvailableLanguageResponse> transformAvailableLanguages(LingoProjectConfiguration configuration) {
        return configuration.getLanguages().stream().map(lingoLanguage -> new AvailableLanguageResponse(lingoLanguage.getLocale().toLanguageTag(), this.lingoProjectLanguageManager.formatDisplayName(lingoLanguage, configuration), lingoLanguage.isActive())).sorted(this.buildResponseComparator(configuration)).collect(Collectors.toList());
    }

    Map<String, String> transformTranslationMap(Map<Locale, Supplier<String>> translations) {
        return translations.entrySet().stream().collect(Collectors.toMap(entry -> ((Locale)entry.getKey()).toLanguageTag(), entry -> (String)((Supplier)entry.getValue()).get()));
    }

    private Comparator<AvailableLanguageResponse> buildResponseComparator(LingoProjectConfiguration configuration) {
        String defaultLocaleKey = configuration.getProjectDefaultLocale().toLanguageTag();
        Comparator isDefaultLangComparator = (first, second) -> {
            if (first.getKey().equals(defaultLocaleKey)) {
                return -1;
            }
            if (second.getKey().equals(defaultLocaleKey)) {
                return 1;
            }
            return 0;
        };
        return isDefaultLangComparator.thenComparing(language -> !language.isActive()).thenComparing(AvailableLanguageResponse::getLabel);
    }
}

