/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.notifications.internal.rest;

import com.atlassian.fugue.Either;
import com.atlassian.jira.bc.project.ProjectService;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.api.commons.jira.ErrorResultHelper;
import com.atlassian.pocketknife.step.Steps;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.api.user.UserFactory;
import com.atlassian.servicedesk.internal.api.rest.RestResponseHelper;
import com.atlassian.servicedesk.plugins.notifications.internal.feature.precondition.NotificationMisconfigurationService;
import io.atlassian.fugue.Unit;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="misconfiguration/{projectKey}/fix")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class NotificationMisconfigurationResource {
    private static final Logger LOG = LoggerFactory.getLogger(NotificationMisconfigurationResource.class);
    private final NotificationMisconfigurationService notificationMisconfigurationService;
    private final UserFactory userFactory;
    private final ProjectService projectService;
    private final ErrorResultHelper errorResultHelper;
    private final RestResponseHelper restResponseHelper;

    public NotificationMisconfigurationResource(NotificationMisconfigurationService notificationMisconfigurationService, UserFactory userFactory, ProjectService projectService, ErrorResultHelper errorResultHelper, RestResponseHelper restResponseHelper) {
        this.notificationMisconfigurationService = notificationMisconfigurationService;
        this.userFactory = userFactory;
        this.projectService = projectService;
        this.errorResultHelper = errorResultHelper;
        this.restResponseHelper = restResponseHelper;
    }

    @POST
    public Response fixNotificationMisconfiguration(@PathParam(value="projectKey") String projectKey) {
        io.atlassian.fugue.Either fixedRules = Steps.begin((io.atlassian.fugue.Either)StepsConverters.newerEither((Either)this.userFactory.getCheckedUser())).then(user -> this.retrieveProjectForUser(user.forJIRA(), projectKey)).then((user, project) -> this.notificationMisconfigurationService.fixMissingNotificationRules(user.forJIRA(), (Project)project)).yield((user, project, createdRules) -> Unit.Unit());
        return this.logErrorsAndReturnResponse((io.atlassian.fugue.Either<AnError, Unit>)fixedRules);
    }

    private io.atlassian.fugue.Either<AnError, Project> retrieveProjectForUser(ApplicationUser applicationUser, String projectKey) {
        ProjectService.GetProjectResult getProjectResult = this.projectService.getProjectByKey(applicationUser, projectKey);
        if (!getProjectResult.isValid()) {
            return io.atlassian.fugue.Either.left((Object)this.errorResultHelper.notFound404("sd.error.project.by.key.not.found", new Object[]{projectKey}).build());
        }
        return io.atlassian.fugue.Either.right((Object)getProjectResult.getProject());
    }

    private Response logErrorsAndReturnResponse(io.atlassian.fugue.Either<AnError, Unit> result) {
        if (result.isLeft()) {
            LOG.error("an error occurred while trying to fix misconfigured notification rules: {}", (Object)((AnError)result.left().get()).getMessage().getMessage());
        }
        return this.restResponseHelper.anErrorEitherToNoContentResponse(result);
    }
}

