/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.notifications.internal.rendering;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.RendererManager;
import com.atlassian.jira.issue.fields.layout.field.FieldLayout;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItem;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutManager;
import com.atlassian.jira.issue.fields.renderer.IssueRenderContext;
import com.atlassian.jira.issue.fields.renderer.JiraRendererPlugin;
import com.atlassian.servicedesk.plugins.notifications.internal.rendering.NotificationRenderFormat;
import com.atlassian.servicedesk.plugins.notifications.internal.rendering.NotificationRendererUtils;
import io.atlassian.fugue.Option;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
class NotificationRendererUtilsImpl
implements NotificationRendererUtils {
    private final FieldLayoutManager fieldLayoutManager;
    private final RendererManager rendererManager;

    @Autowired
    public NotificationRendererUtilsImpl(FieldLayoutManager fieldLayoutManager, RendererManager rendererManager) {
        this.fieldLayoutManager = fieldLayoutManager;
        this.rendererManager = rendererManager;
    }

    @Override
    public String renderWikiContent(String content, Option<Issue> issueOption, NotificationRenderFormat renderFormat) {
        if (renderFormat == NotificationRenderFormat.HTML) {
            return this.renderWikiAsHtml(content, issueOption);
        }
        return this.renderWikiAsPlainText(content, issueOption);
    }

    private String renderWikiAsPlainText(String content, Option<Issue> issueOption) {
        IssueRenderContext renderContext = this.retrieveIssueRenderContext(issueOption);
        return this.retrieveWikiRenderer().renderAsText(content, renderContext);
    }

    private String renderWikiAsHtml(String content, Option<Issue> issueOption) {
        IssueRenderContext renderContext = this.retrieveIssueRenderContext(issueOption);
        return this.retrieveWikiRenderer().render(content, renderContext);
    }

    private IssueRenderContext retrieveIssueRenderContext(Option<Issue> issueOption) {
        return (IssueRenderContext)issueOption.map(Issue::getIssueRenderContext).getOrElse((Object)null);
    }

    private JiraRendererPlugin retrieveWikiRenderer() {
        return this.rendererManager.getRendererForType("atlassian-wiki-renderer");
    }

    @Override
    public String renderFieldContentAsHtml(String rawContent, Issue issue, String fieldId) {
        JiraRendererPlugin renderer = this.retrieveRendererForField(issue, fieldId);
        return renderer.render(rawContent, issue.getIssueRenderContext());
    }

    @Override
    public String renderFieldContentAsPlainText(String rawContent, Issue issue, String fieldId) {
        JiraRendererPlugin renderer = this.retrieveRendererForField(issue, fieldId);
        return renderer.renderAsText(rawContent, issue.getIssueRenderContext());
    }

    @Override
    public JiraRendererPlugin retrieveRendererForField(Issue issue, String fieldId) {
        FieldLayoutItem fieldLayoutItem = this.retrieveFieldLayoutItem(issue, fieldId);
        return this.rendererManager.getRendererForField(fieldLayoutItem);
    }

    private FieldLayoutItem retrieveFieldLayoutItem(Issue issue, String fieldId) {
        FieldLayout fieldLayout = this.fieldLayoutManager.getFieldLayout(issue);
        return fieldLayout.getFieldLayoutItem(fieldId);
    }
}

