/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.notifications.internal.rendering;

import com.atlassian.botocss.Botocss;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.stereotype.Component;

@Component
public class NotificationInternalStylesCssLoader {
    private static final String JIRA_DEV_MODE = "jira.dev.mode";
    private static final String ATLASSIAN_DEV_MODE = "atlassian.dev.mode";
    private static final String STYLESHEET_RESOURCE_PATH = "/servicedesk/internal/notifications/feature/css/";
    private static final String FIXED_STYLESHEET_PATH = "/servicedesk/internal/notifications/feature/css/custom-notifications-fixed-styles.css";
    private static final String DEFAULT_STYLESHEET_PATH = "/servicedesk/internal/notifications/feature/css/custom-notifications-default-styles.css";
    private static final Resource FIXED_STYLESHEET = new ClassPathResource("/servicedesk/internal/notifications/feature/css/custom-notifications-fixed-styles.css");
    private static final Resource DEFAULT_STYLESHEET = new ClassPathResource("/servicedesk/internal/notifications/feature/css/custom-notifications-default-styles.css");
    private final String fixedCss = this.loadCss(FIXED_STYLESHEET);
    private final String defaultCss = this.loadCss(DEFAULT_STYLESHEET);

    public String applyFixedStyles(String html) {
        return Botocss.inject((String)html, (String[])new String[]{this.getFixedCss()});
    }

    public String applyDefaultStyles(String html) {
        return Botocss.inject((String)html, (String[])new String[]{this.getDefaultCss()});
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String loadCss(Resource resource) {
        try (InputStream stream = resource.getInputStream();){
            String string = IOUtils.toString((InputStream)stream, (String)"UTF-8");
            return string;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private String getFixedCss() {
        if (NotificationInternalStylesCssLoader.isDevMode()) {
            return this.loadCss(FIXED_STYLESHEET);
        }
        return this.fixedCss;
    }

    private String getDefaultCss() {
        if (NotificationInternalStylesCssLoader.isDevMode()) {
            return this.loadCss(DEFAULT_STYLESHEET);
        }
        return this.defaultCss;
    }

    private static boolean isDevMode() {
        return Boolean.getBoolean(JIRA_DEV_MODE) || Boolean.getBoolean(ATLASSIAN_DEV_MODE);
    }
}

