/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.notifications.internal.rendering;

import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.servicedesk.internal.api.notifications.model.ServiceDeskEmailBody;
import com.atlassian.servicedesk.internal.api.notifications.render.NotificationLegacyLayoutRenderer;
import com.atlassian.servicedesk.internal.api.notifications.render.RenderedHtmlContent;
import com.atlassian.servicedesk.plugins.notifications.internal.batching.BatchContentRenderer;
import com.atlassian.servicedesk.plugins.notifications.internal.dao.NotificationBatchQueueEntry;
import com.atlassian.servicedesk.plugins.notifications.internal.message.NotificationMessageMetaData;
import com.atlassian.servicedesk.plugins.notifications.internal.message.RecipientNotificationMessage;
import com.atlassian.servicedesk.plugins.notifications.internal.outgoingemail.settings.OutgoingEmailSettingsModel;
import com.atlassian.servicedesk.plugins.notifications.internal.recipients.UserNotificationPreferenceManager;
import com.atlassian.servicedesk.plugins.notifications.internal.rendering.NotificationCSATRenderer;
import com.atlassian.servicedesk.plugins.notifications.internal.rendering.NotificationContentRenderer;
import com.atlassian.servicedesk.plugins.notifications.internal.rendering.NotificationEmailBodyRenderer;
import com.atlassian.servicedesk.plugins.notifications.internal.rendering.NotificationFooterRenderer;
import com.atlassian.servicedesk.plugins.notifications.internal.rendering.NotificationRenderFormat;
import com.atlassian.servicedesk.plugins.notifications.internal.rendering.RenderedHtmlContentImpl;
import com.atlassian.servicedesk.plugins.notifications.internal.rendering.StylingEmailBodyRendererHelper;
import io.atlassian.fugue.Either;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class NotificationEmailBodyRendererImpl
implements NotificationEmailBodyRenderer {
    private final NotificationLegacyLayoutRenderer notificationLegacyLayoutRenderer;
    private final NotificationContentRenderer notificationContentRenderer;
    private final NotificationFooterRenderer notificationFooterRenderer;
    private final NotificationCSATRenderer notificationCSATRenderer;
    private final UserNotificationPreferenceManager userNotificationPreferenceManager;
    private final BatchContentRenderer batchContentRenderer;
    private final FeatureManager featureManager;
    private final StylingEmailBodyRendererHelper stylingEmailBodyRendererHelper;

    @Autowired
    public NotificationEmailBodyRendererImpl(NotificationLegacyLayoutRenderer notificationLegacyLayoutRenderer, NotificationContentRenderer notificationContentRenderer, NotificationFooterRenderer notificationFooterRenderer, NotificationCSATRenderer notificationCSATRenderer, UserNotificationPreferenceManager userNotificationPreferenceManager, BatchContentRenderer batchContentRenderer, FeatureManager featureManager, StylingEmailBodyRendererHelper stylingEmailBodyRendererHelper) {
        this.notificationLegacyLayoutRenderer = notificationLegacyLayoutRenderer;
        this.notificationContentRenderer = notificationContentRenderer;
        this.notificationFooterRenderer = notificationFooterRenderer;
        this.notificationCSATRenderer = notificationCSATRenderer;
        this.userNotificationPreferenceManager = userNotificationPreferenceManager;
        this.batchContentRenderer = batchContentRenderer;
        this.featureManager = featureManager;
        this.stylingEmailBodyRendererHelper = stylingEmailBodyRendererHelper;
    }

    @Override
    public Either<AnError, ServiceDeskEmailBody> renderBatchBody(NotificationMessageMetaData metaData, List<NotificationBatchQueueEntry> entries, OutgoingEmailSettingsModel settingsModel) {
        String htmlContent = this.renderBatchHtmlContent(entries);
        String textContent = this.renderBatchTextContent(entries);
        return this.renderBodyInternal(metaData, textContent, htmlContent, settingsModel);
    }

    @Override
    public Either<AnError, String> renderHtmlContent(RecipientNotificationMessage message) {
        return this.notificationContentRenderer.renderContent(message, NotificationRenderFormat.HTML);
    }

    @Override
    public Either<AnError, String> renderTextContent(RecipientNotificationMessage message) {
        return this.notificationContentRenderer.renderContent(message, NotificationRenderFormat.PLAIN_TEXT);
    }

    private String renderBatchHtmlContent(List<NotificationBatchQueueEntry> entries) {
        List<String> htmlContentEntries = entries.stream().map(NotificationBatchQueueEntry::getHtmlContent).collect(Collectors.toList());
        return this.batchContentRenderer.renderContentAsHtml(htmlContentEntries);
    }

    private String renderBatchTextContent(List<NotificationBatchQueueEntry> entries) {
        List<String> textContentEntries = entries.stream().map(NotificationBatchQueueEntry::getTextContent).collect(Collectors.toList());
        return this.batchContentRenderer.renderContentAsText(textContentEntries);
    }

    private Either<AnError, ServiceDeskEmailBody> renderBodyInternal(NotificationMessageMetaData metaData, String textBody, String htmlBody, OutgoingEmailSettingsModel settingsModel) {
        if (this.isHtmlNotificationPreferred(metaData.getRecipient())) {
            RenderedHtmlContentImpl renderedHtmlContent = new RenderedHtmlContentImpl(textBody, htmlBody);
            return this.renderHtmlBody(metaData, renderedHtmlContent, settingsModel);
        }
        return this.renderTextBody(metaData, textBody, settingsModel);
    }

    private Either<AnError, ServiceDeskEmailBody> renderHtmlBody(NotificationMessageMetaData metaData, RenderedHtmlContent renderedHtmlContent, OutgoingEmailSettingsModel settingsModel) {
        RenderedHtmlContent contentWithCsat = this.notificationCSATRenderer.updateHtmlWithCSATFormIfApplicable(metaData, renderedHtmlContent);
        if (this.featureManager.isEnabled("sd.custom.email.notifications.styling")) {
            return this.stylingEmailBodyRendererHelper.renderHtmlBody(metaData, contentWithCsat, settingsModel);
        }
        return this.renderHtmlWithHardCodedStyling(metaData, contentWithCsat);
    }

    private Either<AnError, ServiceDeskEmailBody> renderTextBody(NotificationMessageMetaData metaData, String textBody, OutgoingEmailSettingsModel settingsModel) {
        String textContentWithCsat = this.notificationCSATRenderer.updatePlainTextWithCSATFormIfApplicable(metaData, textBody);
        if (this.featureManager.isEnabled("sd.custom.email.notifications.styling")) {
            return this.stylingEmailBodyRendererHelper.renderPlainTextBody(metaData, textContentWithCsat, settingsModel);
        }
        return this.renderTextWithHardCodedStyling(metaData, textContentWithCsat);
    }

    private boolean isHtmlNotificationPreferred(ApplicationUser recipient) {
        return this.userNotificationPreferenceManager.isHtmlNotificationPreferred(recipient);
    }

    private Either<AnError, ServiceDeskEmailBody> renderHtmlWithHardCodedStyling(NotificationMessageMetaData metaData, RenderedHtmlContent renderedHtmlContent) {
        RenderedHtmlContent updatedContent = this.notificationFooterRenderer.updateHtmlWithFooterIfApplicable(metaData, renderedHtmlContent);
        return this.notificationLegacyLayoutRenderer.renderHtmlBody(metaData.getRecipient(), updatedContent, metaData.getProject(), metaData.getIssue());
    }

    private Either<AnError, ServiceDeskEmailBody> renderTextWithHardCodedStyling(NotificationMessageMetaData metaData, String textContent) {
        String updatedContent = this.notificationFooterRenderer.updatePlainTextWithFooterIfApplicable(metaData, textContent);
        return this.notificationLegacyLayoutRenderer.renderTextBody(metaData.getRecipient(), updatedContent, metaData.getProject(), metaData.getIssue());
    }
}

