/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.notifications.internal.rendering;

import com.atlassian.jira.project.Project;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.pocketknife.step.Steps;
import com.atlassian.servicedesk.api.portal.Portal;
import com.atlassian.servicedesk.internal.api.ServiceDeskManager;
import com.atlassian.servicedesk.internal.api.analytics.AnalyticsEvent;
import com.atlassian.servicedesk.internal.api.analytics.AnalyticsService;
import com.atlassian.servicedesk.internal.api.analytics.feedbackevents.FeedbackAnalyticEvent;
import com.atlassian.servicedesk.internal.api.feedback.settings.FeedbackSettings;
import com.atlassian.servicedesk.internal.api.feedback.settings.FeedbackSettingsManager;
import com.atlassian.servicedesk.internal.api.notifications.render.NotificationIssueCSATRenderer;
import com.atlassian.servicedesk.internal.api.notifications.render.RenderedHtmlContent;
import com.atlassian.servicedesk.internal.api.portal.PortalManager;
import com.atlassian.servicedesk.internal.api.project.PortalUrlsProvider;
import com.atlassian.servicedesk.internal.api.project.ProjectUrlsProvider;
import com.atlassian.servicedesk.plugins.notifications.internal.message.NotificationMessageMetaData;
import com.atlassian.servicedesk.plugins.notifications.internal.rendering.NotificationCSATRenderer;
import com.atlassian.servicedesk.plugins.notifications.internal.rendering.RenderedHtmlContentImpl;
import com.atlassian.servicedesk.plugins.notifications.internal.rendering.helper.NotificationCSATRendererHelper;
import io.atlassian.fugue.Option;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
class NotificationCSATRendererImpl
implements NotificationCSATRenderer {
    private static final Logger LOG = LoggerFactory.getLogger(NotificationCSATRendererImpl.class);
    private FeedbackSettingsManager feedbackSettingsManager;
    private PortalManager portalManager;
    private PortalUrlsProvider portalUrlsProvider;
    private NotificationIssueCSATRenderer notificationIssueCSATRenderer;
    private ServiceDeskManager serviceDeskManager;
    private AnalyticsService analyticsService;
    private NotificationCSATRendererHelper notificationCSATRendererHelper;

    @Autowired
    public NotificationCSATRendererImpl(FeedbackSettingsManager feedbackSettingsManager, PortalManager portalManager, PortalUrlsProvider portalUrlsProvider, NotificationIssueCSATRenderer notificationIssueCSATRenderer, ServiceDeskManager serviceDeskManager, AnalyticsService analyticsService, NotificationCSATRendererHelper notificationCSATRendererHelper) {
        this.feedbackSettingsManager = feedbackSettingsManager;
        this.portalManager = portalManager;
        this.portalUrlsProvider = portalUrlsProvider;
        this.notificationIssueCSATRenderer = notificationIssueCSATRenderer;
        this.serviceDeskManager = serviceDeskManager;
        this.analyticsService = analyticsService;
        this.notificationCSATRendererHelper = notificationCSATRendererHelper;
    }

    @Override
    public RenderedHtmlContent updateHtmlWithCSATFormIfApplicable(NotificationMessageMetaData metaData, RenderedHtmlContent currentHtmlContent) {
        return (RenderedHtmlContent)this.notificationCSATRendererHelper.generateValidFeedbackToken(metaData).fold(() -> currentHtmlContent, token -> this.getUpdatedHtmlContentIfApplicable((String)token, currentHtmlContent, metaData));
    }

    @Override
    public String updatePlainTextWithCSATFormIfApplicable(NotificationMessageMetaData metaData, String currentPlainTextContent) {
        return (String)this.notificationCSATRendererHelper.generateValidFeedbackToken(metaData).fold(() -> currentPlainTextContent, token -> currentPlainTextContent + this.getTextIssueCSAT((String)token, metaData));
    }

    private RenderedHtmlContent getUpdatedHtmlContentIfApplicable(String token, RenderedHtmlContent currentRenderedHtmlContent, NotificationMessageMetaData messageMetaData) {
        String textCSAT = this.getTextIssueCSAT(token, messageMetaData);
        String htmlCSAT = this.getHtmlIssueCSAT(token, messageMetaData);
        if (StringUtils.isNotEmpty((String)textCSAT) && StringUtils.isNotEmpty((String)htmlCSAT)) {
            return new RenderedHtmlContentImpl(currentRenderedHtmlContent.getTextContent() + textCSAT, currentRenderedHtmlContent.getHtmlContent() + htmlCSAT, true);
        }
        return currentRenderedHtmlContent;
    }

    private String getTextIssueCSAT(String token, NotificationMessageMetaData metaData) {
        Project project = metaData.getProject();
        return (String)Steps.begin(this.getFeedBackSettings(project)).then(feedbackSettings -> metaData.getIssue().flatMap(issue -> Option.option((Object)issue.getKey()))).then((feedbackSettings, issueKey) -> this.getPortalAndFeedbackLinkForRequest(project, (String)issueKey, token)).yield((feedbackSettings, issueKey, feedbackUrl) -> this.fireAnalyticsAndGetTextCSAT(metaData.getRecipient(), (FeedbackSettings)feedbackSettings, (String)feedbackUrl, project.getId())).getOrElse((Object)"");
    }

    private String getHtmlIssueCSAT(String token, NotificationMessageMetaData metaData) {
        Project project = metaData.getProject();
        return (String)Steps.begin(this.getFeedBackSettings(project)).then(feedbackSettings -> metaData.getIssue().flatMap(issue -> Option.option((Object)issue.getKey()))).then((feedbackSettings, issueKey) -> this.getPortalAndFeedbackLinkForRequest(project, (String)issueKey, token)).yield((feedbackSettings, issueKey, feedbackUrl) -> this.notificationIssueCSATRenderer.getHtmlCSAT(metaData.getRecipient(), feedbackSettings, feedbackUrl)).getOrElse((Object)"");
    }

    private Option<FeedbackSettings> getFeedBackSettings(Project project) {
        return this.serviceDeskManager.getServiceDeskForProject(project).map(arg_0 -> ((FeedbackSettingsManager)this.feedbackSettingsManager).getFeedbackSettings(arg_0)).toOption().filter(FeedbackSettings::isEnabled);
    }

    private Option<String> getPortalAndFeedbackLinkForRequest(Project project, String issueKey, String token) {
        return (Option)this.portalManager.getPortalByProject(project).fold(e -> Option.none(), portal -> Option.some((Object)this.getFeedbackLinkForRequest((Portal)portal, issueKey, token)));
    }

    private String getFeedbackLinkForRequest(Portal portal, String issueKey, String token) {
        return this.portalUrlsProvider.getUrls(portal.getId(), ProjectUrlsProvider.UrlMode.ABSOLUTE).feedback(issueKey, token).toString();
    }

    private String fireAnalyticsAndGetTextCSAT(ApplicationUser recipient, FeedbackSettings feedbackSettings, String feedbackUrl, long projectId) {
        this.analyticsService.fireAnalyticsEvent((AnalyticsEvent)new FeedbackAnalyticEvent("servicedesk.action.csat.email.rendered", Long.valueOf(projectId)));
        if (LOG.isDebugEnabled()) {
            LOG.debug("Adding CSAT form to email for '{}'.", (Object)recipient.getEmailAddress());
        }
        return this.notificationIssueCSATRenderer.getTextCSAT(recipient, feedbackSettings, feedbackUrl);
    }
}

