/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.notifications.internal.recipients;

import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.preferences.UserPreferencesManager;
import com.atlassian.servicedesk.plugins.notifications.internal.recipients.UserNotificationPreferenceManager;
import io.atlassian.fugue.Option;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class UserNotificationPreferenceManagerImpl
implements UserNotificationPreferenceManager {
    private static final String HTML_NOTIFICATION_PREFERENCE = "html";
    private final UserPreferencesManager userPreferencesManager;

    @Autowired
    public UserNotificationPreferenceManagerImpl(UserPreferencesManager userPreferencesManager) {
        this.userPreferencesManager = userPreferencesManager;
    }

    @Override
    public boolean isHtmlNotificationPreferred(@Nonnull ApplicationUser user) {
        return (Boolean)this.getNotificationPreferenceProperty(user).map(HTML_NOTIFICATION_PREFERENCE::equalsIgnoreCase).getOrElse((Object)false);
    }

    private Option<String> getNotificationPreferenceProperty(ApplicationUser user) {
        return Option.option((Object)this.userPreferencesManager.getExtendedPreferences(user).getText("user.notifications.mimetype"));
    }
}

