/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.notifications.internal.recipients;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.comments.Comment;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.api.commons.jira.ErrorResultHelper;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.api.user.UserFactory;
import com.atlassian.servicedesk.internal.api.feature.organization.member.CustomerOrganizationMemberService;
import com.atlassian.servicedesk.internal.api.notifications.CommentNotificationUtils;
import com.atlassian.servicedesk.internal.api.notifications.recipients.RecipientConfiguration;
import com.atlassian.servicedesk.internal.api.notifications.recipients.RecipientResolutionManager;
import com.atlassian.servicedesk.internal.api.notifications.recipients.RecipientType;
import com.atlassian.servicedesk.plugins.notifications.internal.configuration.NotificationRecipientType;
import com.atlassian.servicedesk.plugins.notifications.internal.message.NotificationMessage;
import com.atlassian.servicedesk.plugins.notifications.internal.recipients.NotificationRecipientConfiguration;
import com.atlassian.servicedesk.plugins.notifications.internal.recipients.RecipientConfigurationManager;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.atlassian.fugue.Either;
import io.atlassian.fugue.Eithers;
import io.atlassian.fugue.Option;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RecipientConfigurationManagerImpl
implements RecipientConfigurationManager {
    private static final Logger LOG = LoggerFactory.getLogger(RecipientConfigurationManager.class);
    private final ErrorResultHelper errorResultHelper;
    private final RecipientResolutionManager recipientResolutionManager;
    private final CommentNotificationUtils commentNotificationUtils;
    private final CustomerOrganizationMemberService customerOrganizationMemberService;
    private final UserFactory userFactory;
    private final Map<NotificationRecipientType, Function<NotificationMessage, Either<AnError, Set<ApplicationUser>>>> recipientResolverMap = ImmutableMap.builder().put((Object)NotificationRecipientType.REPORTER, this::resolveReporter).put((Object)NotificationRecipientType.NEW_PARTICIPANTS, this::resolveNewParticipants).put((Object)NotificationRecipientType.NEW_APPROVERS, this::resolveNewApprovers).put((Object)NotificationRecipientType.ALL_CUSTOMERS, this::resolveAllCustomers).put((Object)NotificationRecipientType.NEW_ORGANISATIONS, this::resolveNewOrganisations).build();

    @Autowired
    RecipientConfigurationManagerImpl(ErrorResultHelper errorResultHelper, RecipientResolutionManager recipientResolutionManager, CommentNotificationUtils commentNotificationUtils, CustomerOrganizationMemberService customerOrganizationMemberService, UserFactory userFactory) {
        this.errorResultHelper = errorResultHelper;
        this.recipientResolutionManager = recipientResolutionManager;
        this.commentNotificationUtils = commentNotificationUtils;
        this.customerOrganizationMemberService = customerOrganizationMemberService;
        this.userFactory = userFactory;
    }

    @VisibleForTesting
    Map<NotificationRecipientType, Function<NotificationMessage, Either<AnError, Set<ApplicationUser>>>> getRecipientResolvers() {
        return this.recipientResolverMap;
    }

    @Override
    public Either<AnError, Set<ApplicationUser>> getMessageRecipients(NotificationMessage notificationMessage, NotificationRecipientConfiguration recipientConfiguration) {
        return this.getPossibleMessageRecipients(notificationMessage, recipientConfiguration.getNotificationRecipientTypes()).map(unfilteredRecipients -> this.applyExclusions((Set<ApplicationUser>)unfilteredRecipients, notificationMessage, recipientConfiguration));
    }

    private Set<ApplicationUser> applyExclusions(Set<ApplicationUser> unfilteredRecipients, NotificationMessage notificationMessage, NotificationRecipientConfiguration recipientConfiguration) {
        Set<Object> recipientsWithInitiatorExclusionApplied = recipientConfiguration.isExcludeInitiator() ? unfilteredRecipients.stream().filter(recipient -> this.recipientIsNotEventInitiator(notificationMessage, (ApplicationUser)recipient)).collect(Collectors.toSet()) : unfilteredRecipients;
        return this.checkAndRemoveRecipientsOfCommentEmail(notificationMessage.getComment(), recipientsWithInitiatorExclusionApplied);
    }

    private boolean recipientIsNotEventInitiator(NotificationMessage notificationMessage, ApplicationUser recipient) {
        return (Boolean)notificationMessage.getEventInitiator().map(initiator -> !recipient.equals(initiator)).getOrElse((Object)true);
    }

    private Either<AnError, Set<ApplicationUser>> getPossibleMessageRecipients(NotificationMessage notificationMessage, Set<NotificationRecipientType> notificationRecipientTypes) {
        ImmutableSet.Builder recipientSet = ImmutableSet.builder();
        for (NotificationRecipientType recipientType : notificationRecipientTypes) {
            Either<AnError, Set<ApplicationUser>> recipientsAdded = this.resolveRecipients(notificationMessage, recipientType);
            recipientsAdded.map(arg_0 -> ((ImmutableSet.Builder)recipientSet).addAll(arg_0));
            if (!recipientsAdded.isLeft()) continue;
            return Either.left((Object)recipientsAdded.left().get());
        }
        return Either.right((Object)recipientSet.build());
    }

    private Set<ApplicationUser> checkAndRemoveRecipientsOfCommentEmail(Option<Comment> commentOption, Set<ApplicationUser> recipientSet) {
        return (Set)commentOption.fold(() -> recipientSet, comment -> this.removeRecipientsThatArePartOfCommentEmail((Comment)comment, recipientSet));
    }

    private Set<ApplicationUser> removeRecipientsThatArePartOfCommentEmail(Comment comment, Set<ApplicationUser> recipients) {
        return recipients.stream().filter(recipient -> this.isUserNotInEmailListOfCreatedComment(comment, (ApplicationUser)recipient)).collect(Collectors.toSet());
    }

    private boolean isUserNotInEmailListOfCreatedComment(Comment comment, ApplicationUser recipient) {
        boolean userNotInCommentEmailList = (Boolean)this.userFactory.wrap(recipient).fold(e -> {
            LOG.warn(e.getMessage().getMessage());
            return false;
        }, checkedUser -> this.commentNotificationUtils.isUserNotInEmailListOfCreatedComment(checkedUser, comment));
        if (!userNotInCommentEmailList && LOG.isDebugEnabled()) {
            LOG.debug("'{}' was CC'd in the email which created the comment and so will be excluded.", (Object)recipient.getEmailAddress());
        }
        return userNotInCommentEmailList;
    }

    private Either<AnError, Set<ApplicationUser>> resolveRecipients(NotificationMessage notificationMessage, NotificationRecipientType recipientType) {
        return Option.option(this.recipientResolverMap.get((Object)recipientType)).toRight(() -> this.errorResultHelper.internalServiceError500("sd.notifications.base.recipients.recipient.type.missing", new Object[0]).build()).flatMap(resolveRecipientFunction -> (Either)resolveRecipientFunction.apply(notificationMessage));
    }

    private Either<AnError, Set<ApplicationUser>> resolveNewParticipants(NotificationMessage notificationMessage) {
        Supplier<AnError> participantContextMissingError = () -> this.errorResultHelper.internalServiceError500("sd.notifications.base.recipients.new.participants.context.missing", new Object[0]).build();
        return notificationMessage.getNewParticipants().toRight(participantContextMissingError).flatMap(newParticipants -> this.validateUserListNonEmpty((Set<ApplicationUser>)newParticipants, "sd.notifications.base.recipients.new.participants.empty"));
    }

    private Either<AnError, Set<ApplicationUser>> resolveNewOrganisations(NotificationMessage notificationMessage) {
        Supplier<AnError> newOrganisationContextMissingError = () -> this.errorResultHelper.internalServiceError500("sd.notifications.base.recipients.new.organisations.context.missing", new Object[0]).build();
        return notificationMessage.getNewOrganisationIds().toRight(newOrganisationContextMissingError).map(arg_0 -> ((CustomerOrganizationMemberService)this.customerOrganizationMemberService).getOrganizationMembersIgnorePermissionCheck(arg_0));
    }

    private Either<AnError, Set<ApplicationUser>> resolveReporter(NotificationMessage notificationMessage) {
        Supplier<AnError> issueMissingError = () -> this.errorResultHelper.internalServiceError500("sd.notifications.base.recipients.issue.context.missing", new Object[0]).build();
        return notificationMessage.getIssue().toRight(issueMissingError).flatMap(this::resolveReporterForIssue);
    }

    private Either<AnError, Set<ApplicationUser>> resolveReporterForIssue(Issue issue) {
        RecipientConfiguration configuration = RecipientConfiguration.newBuilder().addRecipientIgnoringSubscription(RecipientType.REQUEST_REPORTER).build();
        return this.resolveRecipientsAsApplicationUsers(issue, configuration);
    }

    private Either<AnError, Set<ApplicationUser>> resolveRecipientsAsApplicationUsers(Issue issue, RecipientConfiguration recipientConfiguration) {
        return this.recipientResolutionManager.resolveRecipients(issue, recipientConfiguration).map(checkedUsers -> checkedUsers.stream().map(CheckedUser::forJIRA).collect(Collectors.toSet()));
    }

    private Either<AnError, Set<ApplicationUser>> resolveNewApprovers(NotificationMessage notificationMessage) {
        return notificationMessage.getNewApprovers().toRight(() -> this.errorResultHelper.internalServiceError500("sd.notifications.base.recipients.new.approvers.context.missing", new Object[0]).build()).flatMap(newApprovers -> this.validateUserListNonEmpty((Set<ApplicationUser>)newApprovers, "sd.notifications.base.recipients.new.approvers.empty"));
    }

    private Either<AnError, Set<ApplicationUser>> resolveAllCustomers(NotificationMessage notificationMessage) {
        return notificationMessage.getIssue().toRight(() -> this.errorResultHelper.internalServiceError500("sd.notifications.base.recipients.issue.context.missing", new Object[0]).build()).flatMap(this::resolveAllCustomersForIssue);
    }

    private Either<AnError, Set<ApplicationUser>> resolveAllCustomersForIssue(Issue issue) {
        RecipientConfiguration configuration = RecipientConfiguration.newBuilder().addRecipient(RecipientType.ALL_CUSTOMERS_INVOLVED).build();
        return this.resolveRecipientsAsApplicationUsers(issue, configuration);
    }

    private Either<AnError, Set<ApplicationUser>> validateUserListNonEmpty(Set<ApplicationUser> users, String i18nErrorKeyIfEmpty) {
        return Eithers.cond((!users.isEmpty() ? 1 : 0) != 0, (Object)this.errorResultHelper.internalServiceError500(i18nErrorKeyIfEmpty, new Object[0]).build(), users);
    }
}

