/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.notifications.internal.preview;

import com.atlassian.botocss.Botocss;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.step.Steps;
import com.atlassian.servicedesk.internal.api.notifications.model.ServiceDeskEmailBody;
import com.atlassian.servicedesk.plugins.notifications.internal.configuration.NotificationContext;
import com.atlassian.servicedesk.plugins.notifications.internal.configuration.NotificationVariable;
import com.atlassian.servicedesk.plugins.notifications.internal.message.CustomPreviewData;
import com.atlassian.servicedesk.plugins.notifications.internal.message.NotificationPreviewContext;
import com.atlassian.servicedesk.plugins.notifications.internal.message.StylingPreviewMessageField;
import com.atlassian.servicedesk.plugins.notifications.internal.preview.PreviewSubjectRenderer;
import com.atlassian.servicedesk.plugins.notifications.internal.preview.StylingPreviewData;
import com.atlassian.servicedesk.plugins.notifications.internal.preview.StylingPreviewHelper;
import com.atlassian.servicedesk.plugins.notifications.internal.rendering.NotificationRenderFormat;
import com.atlassian.servicedesk.plugins.notifications.internal.rendering.StylingTestEmailUtils;
import com.atlassian.servicedesk.plugins.notifications.internal.variables.RenderMode;
import com.atlassian.servicedesk.plugins.notifications.internal.variables.styling.StylingRenderer;
import com.google.common.collect.Sets;
import io.atlassian.fugue.Either;
import io.atlassian.fugue.Option;
import io.atlassian.fugue.Pair;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
class StylingPreviewManager {
    private final StylingTestEmailUtils stylingTestEmailUtils;
    private final StylingRenderer stylingRenderer;
    private final PreviewSubjectRenderer previewSubjectRenderer;

    @Autowired
    public StylingPreviewManager(StylingTestEmailUtils stylingTestEmailUtils, StylingRenderer stylingRenderer, PreviewSubjectRenderer previewSubjectRenderer) {
        this.stylingTestEmailUtils = stylingTestEmailUtils;
        this.stylingRenderer = stylingRenderer;
        this.previewSubjectRenderer = previewSubjectRenderer;
    }

    Either<AnError, String> renderPreview(StylingPreviewData data) {
        Either<AnError, String> content = this.renderMultiPurposeContent(data);
        if (data.isRenderHtml()) {
            return content;
        }
        return content.map(StylingPreviewHelper::preformatTextContent);
    }

    Either<AnError, String> sendTestEmail(StylingPreviewData data) {
        if (data.isRenderHtml()) {
            return this.sendHtmlEmail(data);
        }
        return this.sendPlainTextEmail(data);
    }

    private Either<AnError, String> sendPlainTextEmail(StylingPreviewData data) {
        return Steps.begin(this.renderPlainTextPreviewContent(data)).then(plainTextContent -> this.previewSubject(data)).then((plainTextContent, subject) -> this.stylingTestEmailUtils.renderPlainTextBody((String)plainTextContent)).then((plainTextContent, subject, body) -> this.sendEmail(data, (String)subject, (ServiceDeskEmailBody)body)).yield((plainTextContent, subject, body, toAddress) -> toAddress);
    }

    private Either<AnError, String> sendHtmlEmail(StylingPreviewData data) {
        return Steps.begin(this.renderHtmlPreviewContent(data)).then(htmlContent -> this.renderPlainTextPreviewContent(data)).then((htmlContent, plainTextContent) -> this.previewSubject(data)).then((htmlContent, plainTextContent, subject) -> this.stylingTestEmailUtils.renderHtmlBody(data.getUser().forJIRA(), (String)htmlContent, (String)plainTextContent)).then((htmlContent, plainTextContent, subject, body) -> this.sendEmail(data, (String)subject, (ServiceDeskEmailBody)body)).yield((htmlContent, plainTextContent, subject, body, toAddress) -> toAddress);
    }

    private Either<AnError, String> renderHtmlPreviewContent(StylingPreviewData data) {
        return this.stylingRenderer.renderPreview(this.buildNotificationHtmlPreviewContext(data)).map(html -> Botocss.inject((String)html, (String[])new String[]{data.getCss()}));
    }

    private Either<AnError, String> renderPlainTextPreviewContent(StylingPreviewData data) {
        return this.stylingRenderer.renderPreview(this.buildNotificationPlainTextPreviewContext(data, StylingPreviewMessageField.BODY, data.getTextTemplate()));
    }

    private Either<AnError, String> previewSubject(StylingPreviewData data) {
        NotificationPreviewContext context = this.buildNotificationPlainTextPreviewContext(data, StylingPreviewMessageField.SUBJECT, data.getSubjectTemplate());
        return this.previewSubjectRenderer.renderSubject(data.getUser().forJIRA(), context);
    }

    private Either<AnError, String> renderMultiPurposeContent(StylingPreviewData data) {
        Either<AnError, String> content = this.renderPreviewContent(data);
        if (data.isRenderHtml()) {
            return content.map(html -> Botocss.inject((String)html, (String[])new String[]{data.getCss()}));
        }
        return content;
    }

    private Either<AnError, String> renderPreviewContent(StylingPreviewData data) {
        NotificationPreviewContext context = this.buildPreviewContext(data);
        return this.stylingRenderer.renderPreview(context);
    }

    private Either<AnError, String> sendEmail(StylingPreviewData data, String subject, ServiceDeskEmailBody body) {
        return this.stylingTestEmailUtils.sendTestEmail(data.getProject(), data.getUser(), body, subject);
    }

    private NotificationPreviewContext buildPreviewContext(StylingPreviewData data) {
        if (data.isRenderHtml()) {
            return this.buildNotificationHtmlPreviewContext(data);
        }
        return this.buildNotificationPlainTextPreviewContext(data, StylingPreviewMessageField.BODY, data.getTextTemplate());
    }

    private NotificationPreviewContext buildNotificationHtmlPreviewContext(StylingPreviewData data) {
        return new NotificationPreviewContext(data.getHtmlTemplate(), (Option<String>)Option.some((Object)data.getCss()), data.getLocale(), data.getProject(), NotificationRenderFormat.HTML, Sets.newHashSet((Object[])new NotificationContext[]{NotificationContext.NO_CONTEXT, NotificationContext.ISSUE_CONTEXT}), data.getUser(), (Option<Pair<NotificationRenderFormat, String>>)Option.some((Object)new Pair((Object)NotificationRenderFormat.PLAIN_TEXT, (Object)data.getTextTemplate())), RenderMode.STYLING, StylingPreviewMessageField.BODY, (Option<Map<NotificationVariable, CustomPreviewData>>)Option.none());
    }

    private NotificationPreviewContext buildNotificationPlainTextPreviewContext(StylingPreviewData data, StylingPreviewMessageField field, String template) {
        return new NotificationPreviewContext(template, (Option<String>)Option.none(), data.getLocale(), data.getProject(), NotificationRenderFormat.PLAIN_TEXT, Sets.newHashSet((Object[])new NotificationContext[]{NotificationContext.NO_CONTEXT, NotificationContext.ISSUE_CONTEXT}), data.getUser(), (Option<Pair<NotificationRenderFormat, String>>)Option.none(), RenderMode.STYLING, field, (Option<Map<NotificationVariable, CustomPreviewData>>)Option.none());
    }
}

