/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.notifications.internal.preview;

import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.servicedesk.plugins.notifications.internal.message.NotificationPreviewContext;
import com.atlassian.servicedesk.plugins.notifications.internal.variables.styling.StylingRenderer;
import io.atlassian.fugue.Either;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PreviewSubjectRenderer {
    private final I18nHelper.BeanFactory i18nFactory;
    private final StylingRenderer stylingRenderer;

    @Autowired
    public PreviewSubjectRenderer(I18nHelper.BeanFactory i18nFactory, StylingRenderer stylingRenderer) {
        this.i18nFactory = i18nFactory;
        this.stylingRenderer = stylingRenderer;
    }

    public Either<AnError, String> renderSubject(ApplicationUser recipient, NotificationPreviewContext context) {
        return this.stylingRenderer.renderPreview(context).map(subject -> this.retrieveTestEmailSubject(recipient, (String)subject));
    }

    private String retrieveTestEmailSubject(ApplicationUser recipient, String renderedSubject) {
        I18nHelper i18nHelper = this.i18nFactory.getInstance(recipient);
        return i18nHelper.getText("sd.admin.outgoing.email.project.template.send.me.a.test.email.subject", renderedSubject);
    }
}

