/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.notifications.internal.outgoingemail.settings.validation;

import com.atlassian.jira.util.I18nHelper;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.servicedesk.plugins.notifications.internal.outgoingemail.settings.validation.ValidatorUtils;
import com.atlassian.servicedesk.plugins.notifications.internal.subject.EmailSubjectManager;
import com.google.common.collect.ImmutableList;
import io.atlassian.fugue.Either;
import io.atlassian.fugue.Option;
import io.atlassian.fugue.Unit;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
class SubjectValidator {
    private final I18nHelper i18nHelper;
    private final EmailSubjectManager emailSubjectManager;

    @Autowired
    public SubjectValidator(I18nHelper i18nHelper, EmailSubjectManager emailSubjectManager) {
        this.i18nHelper = i18nHelper;
        this.emailSubjectManager = emailSubjectManager;
    }

    public Option<List<String>> validateEmailSubjectInput(Map<Locale, String> emailSubjectInput) {
        return this.validateAtLeastOneLanguageHasSubject(emailSubjectInput).orElse(() -> this.validateSubjectsForEachLanguage(emailSubjectInput));
    }

    private Option<List<String>> validateAtLeastOneLanguageHasSubject(Map<Locale, String> emailSubject) {
        if (ValidatorUtils.isAllEmpty(emailSubject)) {
            return Option.some(Collections.singletonList(this.i18nHelper.getText("sd.admin.outgoing.email.subject.required")));
        }
        return Option.none();
    }

    private Option<List<String>> validateSubjectsForEachLanguage(Map<Locale, String> emailSubject) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Map.Entry<Locale, String> entry : emailSubject.entrySet()) {
            String subjectValue = entry.getValue();
            Either<AnError, Unit> validation = this.emailSubjectManager.validateRequestEmailSubject(subjectValue);
            if (!validation.isLeft()) continue;
            String localeDisplayName = entry.getKey().getDisplayName(this.i18nHelper.getLocale());
            String errorMessage = ((AnError)validation.left().get()).getMessage().getMessage();
            builder.add((Object)(localeDisplayName + ": " + errorMessage));
        }
        ImmutableList errors = builder.build();
        if (!errors.isEmpty()) {
            return Option.some((Object)errors);
        }
        return Option.none();
    }
}

