/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.notifications.internal.outgoingemail.settings.validation;

import com.atlassian.servicedesk.plugins.notifications.internal.outgoingemail.settings.request.OutgoingEmailSettingsInput;
import com.atlassian.servicedesk.plugins.notifications.internal.outgoingemail.settings.validation.SubjectValidator;
import com.atlassian.servicedesk.plugins.notifications.internal.outgoingemail.settings.validation.TemplateValidator;
import com.atlassian.servicedesk.plugins.notifications.internal.outgoingemail.settings.validation.ValidationFailure;
import com.google.common.collect.ImmutableMap;
import io.atlassian.fugue.Either;
import io.atlassian.fugue.Eithers;
import io.atlassian.fugue.Option;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class OutgoingEmailSettingsValidator {
    private static final String SUBJECT_FIELD_NAME = "subject";
    private static final String HTML_FIELD_NAME = "html";
    private static final String PLAIN_TEXT_FIELD_NAME = "plaintext";
    private final TemplateValidator templateValidator;
    private final SubjectValidator emailSubjectValidator;

    @Autowired
    public OutgoingEmailSettingsValidator(TemplateValidator templateValidator, SubjectValidator emailSubjectValidator) {
        this.emailSubjectValidator = emailSubjectValidator;
        this.templateValidator = templateValidator;
    }

    public Either<ValidationFailure, OutgoingEmailSettingsInput> validateInput(OutgoingEmailSettingsInput input) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        Option subjectValidationErrorOpt = input.getEmailSubject().flatMap(subject -> this.emailSubjectValidator.validateEmailSubjectInput((Map<Locale, String>)subject));
        subjectValidationErrorOpt.forEach(validationError -> builder.put((Object)SUBJECT_FIELD_NAME, validationError));
        input.getHtmlTemplate().flatMap(htmlInput -> this.templateValidator.validateHtmlInput((Map<Locale, String>)htmlInput)).forEach(errors -> builder.put((Object)HTML_FIELD_NAME, errors));
        input.getPlainTextTemplate().flatMap(htmlInput -> this.templateValidator.validatePlainTextInput((Map<Locale, String>)htmlInput)).forEach(errors -> builder.put((Object)PLAIN_TEXT_FIELD_NAME, errors));
        ImmutableMap validationErrors = builder.build();
        return Eithers.cond((boolean)validationErrors.isEmpty(), (Object)new ValidationFailure((Map<String, List<String>>)validationErrors), (Object)input);
    }
}

