/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.notifications.internal.outgoingemail.settings;

import com.google.common.base.MoreObjects;
import io.atlassian.fugue.Option;
import java.util.Objects;

public class OutgoingEmailSettingsStoreModel {
    private final long projectId;
    private final Option<Long> subjectLingoId;
    private final Option<Long> htmlTemplateLingoId;
    private final Option<Long> cssLingoId;
    private final Option<Long> plainTextLingoId;

    public OutgoingEmailSettingsStoreModel(long projectId, Long subjectLingoId, Long htmlTemplateLingoId, String cssLingoId, Long plainTextLingoId) {
        this.projectId = projectId;
        this.subjectLingoId = Option.option((Object)subjectLingoId);
        this.htmlTemplateLingoId = Option.option((Object)htmlTemplateLingoId);
        this.cssLingoId = this.fromStringToLong(cssLingoId);
        this.plainTextLingoId = Option.option((Object)plainTextLingoId);
    }

    public long getProjectId() {
        return this.projectId;
    }

    public Option<Long> getSubjectLingoId() {
        return this.subjectLingoId;
    }

    public Option<Long> getHtmlTemplateLingoId() {
        return this.htmlTemplateLingoId;
    }

    public Option<Long> getCssLingoId() {
        return this.cssLingoId;
    }

    public Option<Long> getPlainTextLingoId() {
        return this.plainTextLingoId;
    }

    private Option<Long> fromStringToLong(String cssLingoId) {
        try {
            return Option.option((Object)Long.valueOf(cssLingoId));
        }
        catch (NumberFormatException e) {
            return Option.none();
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OutgoingEmailSettingsStoreModel that = (OutgoingEmailSettingsStoreModel)o;
        return this.projectId == that.projectId && Objects.equals(this.subjectLingoId, that.subjectLingoId) && Objects.equals(this.htmlTemplateLingoId, that.htmlTemplateLingoId) && Objects.equals(this.cssLingoId, that.cssLingoId) && Objects.equals(this.plainTextLingoId, that.plainTextLingoId);
    }

    public int hashCode() {
        return Objects.hash(this.projectId, this.subjectLingoId, this.htmlTemplateLingoId, this.cssLingoId, this.plainTextLingoId);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("projectId", this.projectId).add("subjectLingoId", this.subjectLingoId).add("htmlTemplateLingoId", this.htmlTemplateLingoId).add("cssLingoId", this.cssLingoId).add("plainTextLingoId", this.plainTextLingoId).toString();
    }
}

