/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.notifications.internal.outgoingemail.settings;

import com.atlassian.jira.project.Project;
import com.atlassian.pocketknife.api.querydsl.DatabaseAccessor;
import com.atlassian.pocketknife.api.querydsl.DatabaseConnection;
import com.atlassian.servicedesk.api.ServiceDesk;
import com.atlassian.servicedesk.plugins.notifications.internal.dao.schema.querydsl.Tables;
import com.atlassian.servicedesk.plugins.notifications.internal.outgoingemail.settings.OutgoingEmailSettingsStoreModel;
import com.querydsl.core.dml.StoreClause;
import com.querydsl.core.types.ConstructorExpression;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.SQLQuery;
import com.querydsl.sql.dml.SQLInsertClause;
import com.querydsl.sql.dml.SQLUpdateClause;
import io.atlassian.fugue.Option;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
class OutgoingEmailSettingsStore {
    private final DatabaseAccessor databaseAccessor;

    @Autowired
    public OutgoingEmailSettingsStore(DatabaseAccessor databaseAccessor) {
        this.databaseAccessor = databaseAccessor;
    }

    Option<OutgoingEmailSettingsStoreModel> retrieveSettings(ServiceDesk serviceDesk) {
        return (Option)this.databaseAccessor.runInTransaction(databaseConnection -> this.retrieveSettingsInternal(serviceDesk.getProjectId(), (DatabaseConnection)databaseConnection));
    }

    Option<OutgoingEmailSettingsStoreModel> setEmailSubject(ServiceDesk serviceDesk, Long emailSubject) {
        return (Option)this.databaseAccessor.runInTransaction(databaseConnection -> {
            OutgoingEmailSettingsStoreModel updatedSettings = new OutgoingEmailSettingsStoreModel(serviceDesk.getProjectId(), emailSubject, null, null, null);
            return (Option)this.retrieveSettingsInternal(serviceDesk.getProjectId(), (DatabaseConnection)databaseConnection).fold(() -> this.insertSettings((DatabaseConnection)databaseConnection, updatedSettings), storedSettings -> {
                if (storedSettings.equals(updatedSettings)) {
                    return Option.some((Object)storedSettings);
                }
                return this.updateSettings((DatabaseConnection)databaseConnection, updatedSettings);
            });
        });
    }

    boolean deleteSettings(Project project) {
        return (Boolean)this.databaseAccessor.runInTransaction(databaseConnection -> {
            long deletedRows = databaseConnection.delete((RelationalPath)Tables.OUTGOING_EMAIL_SETTINGS).where((Predicate)Tables.OUTGOING_EMAIL_SETTINGS.PROJECT_ID.eq((Object)project.getId())).execute();
            return deletedRows > 0L;
        });
    }

    Option<OutgoingEmailSettingsStoreModel> insertSettings(OutgoingEmailSettingsStoreModel storeModel) {
        return (Option)this.databaseAccessor.runInTransaction(connection -> this.insertSettings((DatabaseConnection)connection, storeModel));
    }

    private Option<OutgoingEmailSettingsStoreModel> insertSettings(DatabaseConnection databaseConnection, OutgoingEmailSettingsStoreModel storeModel) {
        SQLInsertClause sqlClause = databaseConnection.insert((RelationalPath)Tables.OUTGOING_EMAIL_SETTINGS);
        this.addFieldsToSQLClause((StoreClause)sqlClause, storeModel);
        sqlClause.set(Tables.OUTGOING_EMAIL_SETTINGS.PROJECT_ID, (Object)storeModel.getProjectId()).execute();
        return this.retrieveSettingsInternal(storeModel.getProjectId(), databaseConnection);
    }

    Option<OutgoingEmailSettingsStoreModel> updateSettings(OutgoingEmailSettingsStoreModel storeModel) {
        return (Option)this.databaseAccessor.runInTransaction(connection -> this.updateSettings((DatabaseConnection)connection, storeModel));
    }

    private Option<OutgoingEmailSettingsStoreModel> updateSettings(DatabaseConnection databaseConnection, OutgoingEmailSettingsStoreModel storeModel) {
        SQLUpdateClause sqlUpdateClause = databaseConnection.update((RelationalPath)Tables.OUTGOING_EMAIL_SETTINGS);
        this.addFieldsToSQLClause((StoreClause)sqlUpdateClause, storeModel);
        sqlUpdateClause.where((Predicate)Tables.OUTGOING_EMAIL_SETTINGS.PROJECT_ID.eq((Object)storeModel.getProjectId())).execute();
        return this.retrieveSettingsInternal(storeModel.getProjectId(), databaseConnection);
    }

    private void addFieldsToSQLClause(StoreClause sqlClause, OutgoingEmailSettingsStoreModel storeModel) {
        storeModel.getSubjectLingoId().forEach(id -> sqlClause.set(Tables.OUTGOING_EMAIL_SETTINGS.SUBJECT_LINGO_ID, id));
        storeModel.getHtmlTemplateLingoId().forEach(id -> sqlClause.set(Tables.OUTGOING_EMAIL_SETTINGS.HTML_LINGO_ID, id));
        storeModel.getCssLingoId().forEach(id -> sqlClause.set((Path)Tables.OUTGOING_EMAIL_SETTINGS.CSS, (Object)String.valueOf(id)));
        storeModel.getPlainTextLingoId().forEach(id -> sqlClause.set(Tables.OUTGOING_EMAIL_SETTINGS.PLAINTEXT_LINGO_ID, id));
    }

    private Option<OutgoingEmailSettingsStoreModel> retrieveSettingsInternal(long projectId, DatabaseConnection databaseConnection) {
        OutgoingEmailSettingsStoreModel nullableModel = (OutgoingEmailSettingsStoreModel)((SQLQuery)((SQLQuery)databaseConnection.select(OutgoingEmailSettingsStore.MAPPER()).from((Expression)Tables.OUTGOING_EMAIL_SETTINGS)).where((Predicate)Tables.OUTGOING_EMAIL_SETTINGS.PROJECT_ID.eq((Object)projectId))).fetchFirst();
        return Option.option((Object)nullableModel);
    }

    private static ConstructorExpression<OutgoingEmailSettingsStoreModel> MAPPER() {
        return Projections.constructor(OutgoingEmailSettingsStoreModel.class, (Expression[])new Expression[]{Tables.OUTGOING_EMAIL_SETTINGS.PROJECT_ID, Tables.OUTGOING_EMAIL_SETTINGS.SUBJECT_LINGO_ID, Tables.OUTGOING_EMAIL_SETTINGS.HTML_LINGO_ID, Tables.OUTGOING_EMAIL_SETTINGS.CSS, Tables.OUTGOING_EMAIL_SETTINGS.PLAINTEXT_LINGO_ID});
    }
}

