/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.notifications.internal.outgoingemail.settings;

import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.api.commons.jira.ErrorResultHelper;
import com.atlassian.servicedesk.api.ServiceDesk;
import com.atlassian.servicedesk.api.permission.ServiceDeskPermissionService;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.plugins.notifications.internal.outgoingemail.settings.OutgoingEmailSettingsManager;
import com.atlassian.servicedesk.plugins.notifications.internal.outgoingemail.settings.OutgoingEmailSettingsModel;
import com.atlassian.servicedesk.plugins.notifications.internal.outgoingemail.settings.OutgoingEmailSettingsService;
import com.atlassian.servicedesk.plugins.notifications.internal.outgoingemail.settings.request.OutgoingEmailSettingsInput;
import com.atlassian.servicedesk.plugins.notifications.internal.outgoingemail.settings.validation.ValidationFailure;
import io.atlassian.fugue.Either;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class OutgoingEmailSettingsServiceImpl
implements OutgoingEmailSettingsService {
    private final OutgoingEmailSettingsManager outgoingEmailSettingsManager;
    private final ServiceDeskPermissionService serviceDeskPermissionService;
    private final ErrorResultHelper errorResultHelper;

    @Autowired
    public OutgoingEmailSettingsServiceImpl(OutgoingEmailSettingsManager outgoingEmailSettingsManager, ServiceDeskPermissionService serviceDeskPermissionService, ErrorResultHelper errorResultHelper) {
        this.outgoingEmailSettingsManager = outgoingEmailSettingsManager;
        this.serviceDeskPermissionService = serviceDeskPermissionService;
        this.errorResultHelper = errorResultHelper;
    }

    @Override
    public Either<AnError, OutgoingEmailSettingsModel> retrieveSettings(CheckedUser user, ServiceDesk serviceDesk) {
        return this.checkProjectAdminAgentPermission(user, serviceDesk).flatMap(userWithPermission -> this.outgoingEmailSettingsManager.retrieveSettings(serviceDesk));
    }

    @Override
    public Either<AnError, Either<ValidationFailure, OutgoingEmailSettingsModel>> updateSettings(CheckedUser user, ServiceDesk serviceDesk, OutgoingEmailSettingsInput outgoingEmailSettingsInput) {
        return this.checkProjectAdminAgentPermission(user, serviceDesk).flatMap(userWithPermission -> this.outgoingEmailSettingsManager.updateSettings(serviceDesk, outgoingEmailSettingsInput));
    }

    private Either<AnError, CheckedUser> checkProjectAdminAgentPermission(CheckedUser user, ServiceDesk serviceDesk) {
        boolean isAdminAgent = (Boolean)this.serviceDeskPermissionService.isAdminAgent(user.forJIRA(), serviceDesk).getOrElse((Object)false);
        if (isAdminAgent) {
            return Either.right((Object)user);
        }
        return Either.left((Object)this.errorResultHelper.forbidden403("sd.admin.servicedesk.project.permission", new Object[0]).build());
    }
}

