/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.notifications.internal.outgoingemail.settings;

import com.atlassian.jira.util.I18nHelper;
import com.atlassian.servicedesk.api.ServiceDesk;
import com.atlassian.servicedesk.internal.api.notifications.render.NotificationMessageContextUtils;
import com.atlassian.servicedesk.internal.api.util.SoyTemplateRenderer;
import com.atlassian.servicedesk.plugins.notifications.internal.configuration.StylingVariable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public abstract class AbstractOutgoingMailTemplateProvider {
    private final SoyTemplateRenderer soyTemplateRenderer;
    private final I18nHelper.BeanFactory i18nBeanFactory;
    private final NotificationMessageContextUtils notificationMessageContextUtils;

    public AbstractOutgoingMailTemplateProvider(SoyTemplateRenderer soyTemplateRenderer, I18nHelper.BeanFactory i18nBeanFactory, NotificationMessageContextUtils notificationMessageContextUtils) {
        this.soyTemplateRenderer = soyTemplateRenderer;
        this.i18nBeanFactory = i18nBeanFactory;
        this.notificationMessageContextUtils = notificationMessageContextUtils;
    }

    public String getDefaultTemplate(Locale locale, ServiceDesk serviceDesk) {
        boolean shouldAddReplyMarker = this.notificationMessageContextUtils.isMarkerInsertionEnabledForServiceDesk(serviceDesk);
        return this.soyTemplateRenderer.render("com.atlassian.servicedesk.servicedesk-notifications-plugin:soy", this.getTemplateName(), this.getRenderParams(locale, shouldAddReplyMarker));
    }

    protected Map<String, Object> getRenderParams(Locale locale, boolean shouldAddReplyMarker) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("peopleInvolveTranslatedText", this.getText("sd.email.participants.involved.label", locale, new Object[0]));
        map.put("helpCenterVariable", String.format("${%s}", StylingVariable.HELP_CENTER_NAME.getVariable()));
        map.put("viewRequestTranslatedText", this.getText("sd.notifications.footer.view.request", locale, new Object[0]));
        map.put("turnOffNotificationTranslatedText", this.getText("sd.notifications.footer.turn.off.notifications", locale, new Object[0]));
        if (shouldAddReplyMarker) {
            map.put("replyAboveHintText", this.getText("sd.notifications.reply.above.hint", locale, new Object[0]));
        }
        return Collections.unmodifiableMap(map);
    }

    protected String getText(String i18nKey, Locale locale, Object ... args) {
        return this.i18nBeanFactory.getInstance(locale).getText(i18nKey, (Object)args);
    }

    protected abstract String getTemplateName();
}

