/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.notifications.internal.message;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.comments.Comment;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.servicedesk.internal.api.lingo.response.Lingo;
import com.atlassian.servicedesk.internal.api.lingo.response.LingoTranslation;
import com.atlassian.servicedesk.internal.api.listener.FieldChangeType;
import com.atlassian.servicedesk.plugins.automation.modules.internal.api.rulewhen.helper.StatusChange;
import com.atlassian.servicedesk.plugins.notifications.internal.message.NotificationMessage;
import com.google.common.base.Preconditions;
import io.atlassian.fugue.Option;
import java.util.Date;
import java.util.Set;

public final class NotificationMessageBuilder {
    private Option<Issue> issue = Option.none();
    private Option<Comment> comment = Option.none();
    private Option<ApplicationUser> eventInitiator = Option.none();
    private Option<Set<ApplicationUser>> newParticipants = Option.none();
    private Option<Set<ApplicationUser>> newApprovers = Option.none();
    private Option<Set<Integer>> newOrganisations = Option.none();
    private Option<FieldChangeType> resolutionChangeType = Option.none();
    private Option<StatusChange> statusChange = Option.none();
    private Option<Lingo> lingo = Option.none();
    private Project project;
    private Date eventTime;
    private Option<LingoTranslation> legacyTranslation = Option.none();

    public static NotificationMessageBuilder newBuilder() {
        return new NotificationMessageBuilder();
    }

    private NotificationMessageBuilder() {
    }

    public NotificationMessageBuilder comment(Comment comment) {
        this.comment = Option.some((Object)comment);
        return this;
    }

    public NotificationMessageBuilder issue(Issue issue) {
        this.issue = Option.some((Object)issue);
        return this;
    }

    public NotificationMessageBuilder project(Project project) {
        this.project = project;
        return this;
    }

    public NotificationMessageBuilder newParticipants(Set<ApplicationUser> newParticipants) {
        this.newParticipants = Option.some(newParticipants);
        return this;
    }

    public NotificationMessageBuilder newOrganisations(Set<Integer> organisationIds) {
        this.newOrganisations = Option.some(organisationIds);
        return this;
    }

    public NotificationMessageBuilder newApprovers(Set<ApplicationUser> newApprovers) {
        this.newApprovers = Option.some(newApprovers);
        return this;
    }

    public NotificationMessageBuilder eventInitiator(ApplicationUser eventInitiator) {
        this.eventInitiator = Option.some((Object)eventInitiator);
        return this;
    }

    public NotificationMessageBuilder resolutionChangeType(FieldChangeType resolutionChangeType) {
        this.resolutionChangeType = Option.some((Object)resolutionChangeType);
        return this;
    }

    public NotificationMessageBuilder eventTime(Date eventTime) {
        this.eventTime = eventTime;
        return this;
    }

    public NotificationMessageBuilder statusChange(StatusChange statusChange) {
        this.statusChange = Option.some((Object)statusChange);
        return this;
    }

    public NotificationMessageBuilder lingo(Lingo lingo) {
        this.lingo = Option.option((Object)lingo);
        return this;
    }

    public NotificationMessageBuilder legacyTranslation(LingoTranslation legacyTranslation) {
        this.legacyTranslation = Option.option((Object)legacyTranslation);
        return this;
    }

    private void validate() {
        if (this.legacyTranslation.isEmpty() && this.lingo.isEmpty()) {
            throw new IllegalStateException("default translation or lingo is required for NotificationMessage");
        }
        Preconditions.checkNotNull((Object)this.project);
        Preconditions.checkNotNull((Object)this.eventTime);
    }

    public NotificationMessage build() {
        this.validate();
        return new NotificationMessage(this.issue, this.comment, this.eventInitiator, this.newParticipants, this.newApprovers, this.newOrganisations, this.resolutionChangeType, this.eventTime, this.project, this.statusChange, this.lingo, this.legacyTranslation);
    }
}

