/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.notifications.internal.feature.precondition;

import com.atlassian.jira.project.Project;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.servicedesk.api.ServiceDesk;
import com.atlassian.servicedesk.api.permission.ServiceDeskPermissionService;
import com.atlassian.servicedesk.api.portal.Portal;
import com.atlassian.servicedesk.api.user.UserFactory;
import com.atlassian.servicedesk.internal.api.feature.precondition.Alert;
import com.atlassian.servicedesk.internal.api.feature.precondition.AlertSeverity;
import com.atlassian.servicedesk.internal.api.feature.precondition.Precondition;
import com.atlassian.servicedesk.plugins.notifications.internal.bootstrap.upgrade.task.NotificationDefaultRuleDefaults;
import com.atlassian.servicedesk.plugins.notifications.internal.bootstrap.upgrade.task.NotificationDefaultRuleDescriptor;
import com.atlassian.servicedesk.plugins.notifications.internal.defaultrules.migration.NotificationDefaultRuleGenerator;
import com.atlassian.servicedesk.plugins.notifications.internal.migration.MigrationStatusChecker;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.BooleanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@ExportAsService
public class DefaultRulesCreatedPrecondition
implements Precondition {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultRulesCreatedPrecondition.class);
    private final UserFactory userFactory;
    private final I18nHelper i18nHelper;
    private final ServiceDeskPermissionService serviceDeskPermissionService;
    private final NotificationDefaultRuleGenerator defaultRuleGenerator;
    private final NotificationDefaultRuleDefaults notificationDefaultRuleDefaults;
    private final MigrationStatusChecker migrationStatusChecker;

    @Autowired
    public DefaultRulesCreatedPrecondition(UserFactory userFactory, I18nHelper i18nHelper, ServiceDeskPermissionService serviceDeskPermissionService, NotificationDefaultRuleGenerator defaultRuleGenerator, NotificationDefaultRuleDefaults notificationDefaultRuleDefaults, MigrationStatusChecker migrationStatusChecker) {
        this.userFactory = userFactory;
        this.i18nHelper = i18nHelper;
        this.serviceDeskPermissionService = serviceDeskPermissionService;
        this.defaultRuleGenerator = defaultRuleGenerator;
        this.notificationDefaultRuleDefaults = notificationDefaultRuleDefaults;
        this.migrationStatusChecker = migrationStatusChecker;
    }

    public List<Alert> checkPrecondition(ServiceDesk serviceDesk, Project project, Portal portal) {
        if (this.migrationStatusChecker.isDefaultNotificationSendingEnabled()) {
            return (List)this.userFactory.getCheckedUser().flatMap(user -> this.serviceDeskPermissionService.isAdminAgent(user.forJIRA(), serviceDesk)).fold(anError -> Collections.emptyList(), canAdministerServiceDesk -> this.createAdminAlertsForMissingRules((Boolean)canAdministerServiceDesk, project));
        }
        return Collections.emptyList();
    }

    private List<Alert> createAdminAlertsForMissingRules(Boolean canAdministerProject, Project project) {
        if (BooleanUtils.isTrue((Boolean)canAdministerProject)) {
            return (List)this.defaultRuleGenerator.retrieveMissingRules(project, this.notificationDefaultRuleDefaults.getAllSystemRuleDescriptors(false)).fold(anError -> this.logErrorAndReturnEmptyList((AnError)anError), missingRules -> this.createErrorMessage(this.filterMigrationInProgressRule((List<NotificationDefaultRuleDescriptor>)missingRules)));
        }
        return Collections.emptyList();
    }

    private List<Alert> logErrorAndReturnEmptyList(AnError anError) {
        LOG.error("An error occurred while running the precondition check for notification rules: {}", (Object)anError.getMessage().getMessage());
        return Collections.emptyList();
    }

    private List<NotificationDefaultRuleDescriptor> filterMigrationInProgressRule(List<NotificationDefaultRuleDescriptor> descriptors) {
        ArrayList<NotificationDefaultRuleDescriptor> missingRuleDescriptors = new ArrayList<NotificationDefaultRuleDescriptor>(descriptors);
        if (!this.migrationStatusChecker.isOrganisationAddedRuleMigrationDone()) {
            missingRuleDescriptors.remove(this.notificationDefaultRuleDefaults.getOrganisationAddedRuleDescriptor());
        }
        return ImmutableList.copyOf(missingRuleDescriptors);
    }

    private List<Alert> createErrorMessage(List<NotificationDefaultRuleDescriptor> descriptors) {
        if (!descriptors.isEmpty()) {
            Alert message = new Alert(AlertSeverity.ERROR_ALERT, this.i18nHelper.getText("sd.admin.alert.notification.misconfig.summary"), "defaultNotificationRuleAlert", (Map)ImmutableMap.of());
            return ImmutableList.of((Object)message);
        }
        return Collections.emptyList();
    }
}

