/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.notifications.internal.dispatch;

import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.api.commons.jira.ErrorResultHelper;
import com.atlassian.servicedesk.api.customer.CustomerContextService;
import com.atlassian.servicedesk.plugins.notifications.internal.analytics.NotificationAnalyticsEventHelper;
import com.atlassian.servicedesk.plugins.notifications.internal.dispatch.NotificationBatchEntryCreatorFactory;
import com.atlassian.servicedesk.plugins.notifications.internal.dispatch.NotificationMessageConsumer;
import com.atlassian.servicedesk.plugins.notifications.internal.message.RecipientNotificationMessage;
import com.atlassian.servicedesk.plugins.notifications.internal.security.NotificationPermissionService;
import com.google.common.collect.ImmutableList;
import io.atlassian.fugue.Either;
import io.atlassian.fugue.Maybe;
import io.atlassian.fugue.Unit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class NotificationMessageProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(NotificationMessageProcessor.class);
    private static final String SEPARATOR = "; ";
    private final ErrorResultHelper errorResultHelper;
    private final NotificationPermissionService notificationPermissionService;
    private final NotificationBatchEntryCreatorFactory notificationBatchEntryCreatorFactory;
    private final CustomerContextService customerContextService;
    private final NotificationAnalyticsEventHelper notificationAnalyticsEventHelper;

    @Autowired
    public NotificationMessageProcessor(ErrorResultHelper errorResultHelper, NotificationPermissionService notificationPermissionService, NotificationBatchEntryCreatorFactory notificationBatchEntryCreatorFactory, CustomerContextService customerContextService, NotificationAnalyticsEventHelper notificationAnalyticsEventHelper) {
        this.errorResultHelper = errorResultHelper;
        this.notificationPermissionService = notificationPermissionService;
        this.notificationBatchEntryCreatorFactory = notificationBatchEntryCreatorFactory;
        this.customerContextService = customerContextService;
        this.notificationAnalyticsEventHelper = notificationAnalyticsEventHelper;
    }

    public Either<AnError, Unit> process(List<RecipientNotificationMessage> messages) {
        ArrayList<AnError> errors = new ArrayList<AnError>();
        List<NotificationMessageConsumer> consumers = this.retrieveConsumers();
        for (RecipientNotificationMessage message : messages) {
            this.customerContextService.runInCustomerContext(() -> errors.addAll(this.processMessage(consumers, message)));
        }
        consumers.forEach(NotificationMessageConsumer::finalizeConsumption);
        if (!errors.isEmpty()) {
            return Either.left((Object)this.collateErrors(errors));
        }
        return Either.right((Object)Unit.VALUE);
    }

    private List<AnError> processMessage(List<NotificationMessageConsumer> consumers, RecipientNotificationMessage message) {
        if (this.notificationPermissionService.isAllowedToReceiveMessage(message)) {
            return consumers.stream().map(consumer -> consumer.consume(message).left().toOption()).filter(Maybe::isDefined).map(Maybe::get).collect(Collectors.toList());
        }
        this.trackUserNotAllowedToReceiveMessage(message);
        return Collections.emptyList();
    }

    private List<NotificationMessageConsumer> retrieveConsumers() {
        ImmutableList.Builder listBuilder = ImmutableList.builder();
        listBuilder.add((Object)this.notificationBatchEntryCreatorFactory.newCreator());
        return listBuilder.build();
    }

    private AnError collateErrors(List<AnError> errors) {
        List errorMessages = errors.stream().map(e -> e.getMessage().getMessage()).collect(Collectors.toList());
        return this.errorResultHelper.internalServiceError500("sd.notification.dispatch.error", new Object[]{StringUtils.join(errorMessages, (String)SEPARATOR)}).build();
    }

    private void trackUserNotAllowedToReceiveMessage(RecipientNotificationMessage message) {
        String issueIdOrNone = (String)message.getIssue().map(issue -> Long.toString(issue.getId())).getOrElse((Object)"(none)");
        if (LOG.isDebugEnabled()) {
            LOG.debug("'{}' is not allowed to receive this message for issue '{}'.", (Object)message.getRecipient().getEmailAddress(), (Object)issueIdOrNone);
        }
        this.notificationAnalyticsEventHelper.fireAnalyticsEvent("servicedesk.custom.notifications.recipients.invalid.recipient", message.getProject().getId());
    }
}

