/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.notifications.internal.dispatch;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.step.Steps;
import com.atlassian.servicedesk.api.customer.CustomerContextService;
import com.atlassian.servicedesk.internal.api.listener.FieldChangeType;
import com.atlassian.servicedesk.internal.api.notifications.ServiceDeskNotificationSender;
import com.atlassian.servicedesk.internal.api.notifications.model.ServiceDeskEmail;
import com.atlassian.servicedesk.internal.api.notifications.model.ServiceDeskEmailBody;
import com.atlassian.servicedesk.plugins.notifications.internal.analytics.NotificationAnalyticsEventHelper;
import com.atlassian.servicedesk.plugins.notifications.internal.dao.NotificationBatchQueueEntry;
import com.atlassian.servicedesk.plugins.notifications.internal.dispatch.NotificationBatchKey;
import com.atlassian.servicedesk.plugins.notifications.internal.dispatch.NotificationBatchQueueEntryComparator;
import com.atlassian.servicedesk.plugins.notifications.internal.dispatch.NotificationDispatchUtils;
import com.atlassian.servicedesk.plugins.notifications.internal.dispatch.NotificationEntryCollector;
import com.atlassian.servicedesk.plugins.notifications.internal.message.NotificationMessageMetaData;
import com.atlassian.servicedesk.plugins.notifications.internal.outgoingemail.settings.OutgoingEmailSettingsModel;
import com.atlassian.servicedesk.plugins.notifications.internal.outgoingemail.settings.memo.OutgoingEmailSettingsMemo;
import com.atlassian.servicedesk.plugins.notifications.internal.outgoingemail.settings.memo.OutgoingEmailSettingsMemoFactory;
import com.atlassian.servicedesk.plugins.notifications.internal.rendering.NotificationEmailBodyRenderer;
import io.atlassian.fugue.Either;
import io.atlassian.fugue.Option;
import io.atlassian.fugue.Unit;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class NotificationBatchDispatcher {
    private static final Logger LOG = LoggerFactory.getLogger(NotificationBatchDispatcher.class);
    private static final long MINIMUM_AGE_POSTPONE_DISPATCH_IN_SECONDS = 10L;
    private static final long MAXIMUM_POSTPONE_OVERRIDE_IN_SECONDS = 60L;
    private final NotificationDispatchUtils notificationDispatchUtils;
    private final NotificationEmailBodyRenderer notificationEmailBodyRenderer;
    private final UserManager userManager;
    private final IssueManager issueManager;
    private final ProjectManager projectManager;
    private final ServiceDeskNotificationSender serviceDeskNotificationSender;
    private final NotificationAnalyticsEventHelper notificationAnalyticsEventHelper;
    private final OutgoingEmailSettingsMemoFactory outgoingEmailSettingsMemoFactory;
    private final CustomerContextService customerContextService;

    @Autowired
    public NotificationBatchDispatcher(NotificationDispatchUtils notificationDispatchUtils, NotificationEmailBodyRenderer notificationEmailBodyRenderer, UserManager userManager, IssueManager issueManager, ProjectManager projectManager, ServiceDeskNotificationSender serviceDeskNotificationSender, NotificationAnalyticsEventHelper notificationAnalyticsEventHelper, OutgoingEmailSettingsMemoFactory outgoingEmailSettingsMemoFactory, CustomerContextService customerContextService) {
        this.notificationDispatchUtils = notificationDispatchUtils;
        this.notificationEmailBodyRenderer = notificationEmailBodyRenderer;
        this.userManager = userManager;
        this.issueManager = issueManager;
        this.projectManager = projectManager;
        this.serviceDeskNotificationSender = serviceDeskNotificationSender;
        this.notificationAnalyticsEventHelper = notificationAnalyticsEventHelper;
        this.outgoingEmailSettingsMemoFactory = outgoingEmailSettingsMemoFactory;
        this.customerContextService = customerContextService;
    }

    public List<Long> dispatchEmail(List<NotificationBatchQueueEntry> entries, boolean forceSend) {
        Instant now = Instant.now();
        Map<NotificationBatchKey, List<NotificationBatchQueueEntry>> map = this.splitEntriesByRecipientAndIssue(entries);
        ArrayList<Long> dispatchedEntries = new ArrayList<Long>();
        OutgoingEmailSettingsMemo settingsMemo = this.outgoingEmailSettingsMemoFactory.createNewOutgoingEmailSettingsMemo();
        for (NotificationBatchKey key : map.keySet()) {
            dispatchedEntries.addAll(this.dispatchEmailPerIssueAndRecipient(now, this.sortEntries(map.get(key)), settingsMemo, forceSend));
        }
        return Collections.unmodifiableList(dispatchedEntries);
    }

    private List<Long> dispatchEmailPerIssueAndRecipient(Instant now, List<NotificationBatchQueueEntry> entries, OutgoingEmailSettingsMemo settingsMemo, boolean forceSend) {
        try {
            return (List)this.customerContextService.runInCustomerContext(() -> this.internaldispatchEmailPerIssueAndRecipient(now, entries, settingsMemo, forceSend));
        }
        catch (Exception e) {
            LOG.error("Unable to send email notifications.", (Throwable)e);
            return entries.stream().map(NotificationBatchQueueEntry::getId).collect(Collectors.toList());
        }
    }

    private List<Long> internaldispatchEmailPerIssueAndRecipient(Instant now, List<NotificationBatchQueueEntry> entries, OutgoingEmailSettingsMemo settingsMemo, boolean forceSend) {
        if (forceSend || this.isBatchReadyToSend(now, entries)) {
            NotificationBatchQueueEntry firstEntry = this.retrieveFirstEntry(entries);
            Steps.begin(this.retrieveRecipient(firstEntry)).then(recipient -> this.retrieveProject(firstEntry)).then((recipient, project) -> this.retrieveIssue(firstEntry)).then((recipient, project, issueOption) -> this.retrieveSettings((Project)project, settingsMemo)).yield((recipient, project, issueOption, settings) -> this.dispatchMail(entries, (ApplicationUser)recipient, (Project)project, (Option<Issue>)issueOption, (OutgoingEmailSettingsModel)settings));
            return entries.stream().map(NotificationBatchQueueEntry::getId).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    private NotificationBatchQueueEntry retrieveFirstEntry(List<NotificationBatchQueueEntry> entries) {
        return entries.get(0);
    }

    private List<NotificationBatchQueueEntry> sortEntries(List<NotificationBatchQueueEntry> entries) {
        NotificationBatchQueueEntryComparator comparator = new NotificationBatchQueueEntryComparator();
        return Collections.unmodifiableList(entries.stream().sorted(comparator).collect(Collectors.toList()));
    }

    private Unit dispatchMail(List<NotificationBatchQueueEntry> entries, ApplicationUser recipient, Project project, Option<Issue> issueOption, OutgoingEmailSettingsModel settings) {
        Option<FieldChangeType> resolutionChangeOption = this.retrieveResolutionChange(entries);
        NotificationMessageMetaData metaData = new NotificationMessageMetaData(recipient, project, issueOption, resolutionChangeOption);
        this.buildEmail(metaData, entries, settings).forEach(arg_0 -> ((ServiceDeskNotificationSender)this.serviceDeskNotificationSender).send(arg_0));
        this.trackMessageSent(recipient, issueOption, project.getId(), entries.size());
        return Unit.Unit();
    }

    private Option<FieldChangeType> retrieveResolutionChange(List<NotificationBatchQueueEntry> entries) {
        if (entries.stream().anyMatch(this::isResolvedEntry)) {
            return Option.some((Object)FieldChangeType.SET);
        }
        return Option.none();
    }

    private boolean isResolvedEntry(NotificationBatchQueueEntry entry) {
        return entry.getContext().exists("RESOLVED"::equals);
    }

    private Either<AnError, ServiceDeskEmail> buildEmail(NotificationMessageMetaData metaData, List<NotificationBatchQueueEntry> entries, OutgoingEmailSettingsModel settings) {
        return Steps.begin(this.notificationEmailBodyRenderer.renderBatchBody(metaData, entries, settings)).then(emailBody -> this.notificationDispatchUtils.buildEmailWithContent(metaData, entries, (ServiceDeskEmailBody)emailBody, settings)).yield((emailBody, serviceDeskEmail) -> serviceDeskEmail).leftMap(error -> {
            this.trackProcessingError(metaData);
            return error;
        });
    }

    private void trackProcessingError(NotificationMessageMetaData metaData) {
        this.notificationAnalyticsEventHelper.fireAnalyticsEvent("servicedesk.custom.notifications.dispatch.processing.error", metaData.getProject().getId());
    }

    private Map<NotificationBatchKey, List<NotificationBatchQueueEntry>> splitEntriesByRecipientAndIssue(List<NotificationBatchQueueEntry> entries) {
        return entries.stream().collect(new NotificationEntryCollector());
    }

    private Either<Unit, Project> retrieveProject(NotificationBatchQueueEntry entry) {
        return (Either)Option.option((Object)this.projectManager.getProjectObj(Long.valueOf(entry.getProjectId()))).fold(() -> Either.left((Object)Unit.Unit()), Either::right);
    }

    private Either<Unit, Option<Issue>> retrieveIssue(NotificationBatchQueueEntry entry) {
        return (Either)entry.getIssueId().fold(() -> Either.right((Object)Option.none()), issueId -> (Either)Option.option((Object)this.issueManager.getIssueObject(issueId)).fold(() -> Either.left((Object)Unit.Unit()), issue -> Either.right((Object)Option.some((Object)issue))));
    }

    private Either<Unit, OutgoingEmailSettingsModel> retrieveSettings(Project project, OutgoingEmailSettingsMemo settingsMemo) {
        long projectId = project.getId();
        return settingsMemo.retrieveSettingsForServiceDesk(projectId).toRight(() -> {
            LOG.error("Failed to retrieve Service Desk notification settings for project with ID " + projectId);
            return Unit.Unit();
        });
    }

    private Either<Unit, ApplicationUser> retrieveRecipient(NotificationBatchQueueEntry entry) {
        return (Either)Option.option((Object)this.userManager.getUserById(Long.valueOf(entry.getRecipientID())).orElseGet(() -> null)).fold(() -> Either.left((Object)Unit.Unit()), Either::right);
    }

    private void trackMessageSent(ApplicationUser recipient, Option<Issue> issueOpt, long projectId, int numEntries) {
        String issueIdOrNone = (String)issueOpt.map(issue -> Long.toString(issue.getId())).getOrElse((Object)"(none)");
        LOG.debug("Batched message with {} entries sent to user '{}', for issue ID: {}", new Object[]{numEntries, recipient.getUsername(), issueIdOrNone});
        this.notificationAnalyticsEventHelper.analyticsBatchMessageEvent(projectId, numEntries);
    }

    private boolean isBatchReadyToSend(Instant now, List<NotificationBatchQueueEntry> entries) {
        Instant minimumAgePostponeTime = now.minusSeconds(10L);
        Instant maxmimumPostponeOverrideTime = now.minusSeconds(60L);
        boolean batchHasTooYoungEntry = entries.stream().anyMatch(entry -> minimumAgePostponeTime.isBefore(entry.getEventTime().toInstant()));
        boolean batchHasOverrideEntry = entries.stream().anyMatch(entry -> maxmimumPostponeOverrideTime.isAfter(entry.getEventTime().toInstant()));
        return !batchHasTooYoungEntry || batchHasOverrideEntry;
    }
}

