/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.notifications.internal.dispatch;

import com.atlassian.servicedesk.internal.api.listener.FieldChangeType;
import com.atlassian.servicedesk.plugins.notifications.internal.message.RecipientNotificationMessage;
import io.atlassian.fugue.Option;

class NotificationBatchContextResolver {
    NotificationBatchContextResolver() {
    }

    Option<String> determineContext(RecipientNotificationMessage message) {
        if (this.isInResolvedContext(message)) {
            return Option.some((Object)"RESOLVED");
        }
        if (this.isInReopenContext(message)) {
            return Option.some((Object)"REOPEN");
        }
        if (this.isInStatusContext(message)) {
            return Option.some((Object)"STATUS");
        }
        if (this.isInCommentContext(message)) {
            return Option.some((Object)"COMMENT");
        }
        return Option.none();
    }

    private boolean isInStatusContext(RecipientNotificationMessage message) {
        return message.getStatusChange().isDefined();
    }

    private boolean isInResolvedContext(RecipientNotificationMessage message) {
        return message.getResolutionChangeType().filter(arg_0 -> FieldChangeType.SET.equals(arg_0)).isDefined();
    }

    private boolean isInReopenContext(RecipientNotificationMessage message) {
        return message.getResolutionChangeType().filter(arg_0 -> FieldChangeType.CLEAR.equals(arg_0)).isDefined();
    }

    private boolean isInCommentContext(RecipientNotificationMessage message) {
        return message.getComment().isDefined();
    }
}

