/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.notifications.internal.defaultrules.migration;

import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.servicedesk.internal.api.notifications.GlobalNotificationsManager;
import com.atlassian.servicedesk.internal.api.project.type.ServiceDeskProjectType;
import com.atlassian.servicedesk.plugins.notifications.internal.defaultrules.migration.NotificationProjectUpgradeManager;
import com.atlassian.servicedesk.plugins.notifications.internal.defaultrules.migration.NotificationUpgradeUser;
import io.atlassian.fugue.Either;
import io.atlassian.fugue.Eithers;
import io.atlassian.fugue.Unit;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class NotificationUpgradeTaskManager {
    private static final Logger LOG = LoggerFactory.getLogger(NotificationUpgradeTaskManager.class);
    private final ProjectManager projectManager;
    private final NotificationProjectUpgradeManager notificationProjectUpgradeManager;
    private final GlobalNotificationsManager globalNotificationsManager;

    @Autowired
    public NotificationUpgradeTaskManager(ProjectManager projectManager, NotificationProjectUpgradeManager notificationProjectUpgradeManager, GlobalNotificationsManager globalNotificationsManager) {
        this.projectManager = projectManager;
        this.notificationProjectUpgradeManager = notificationProjectUpgradeManager;
        this.globalNotificationsManager = globalNotificationsManager;
    }

    public Either<List<String>, Unit> upgradeInstance() {
        return this.upgradeAllProjects();
    }

    private Either<List<String>, Unit> upgradeAllProjects() {
        ArrayList<Object> projectErrors = new ArrayList<Object>();
        for (Project project : this.getServiceDeskProjects()) {
            Either<String, Unit> projectEither = this.upgradeProject(project);
            if (!projectEither.isLeft()) continue;
            LOG.warn("Problem encountered while upgrading project '{}' with default custom notifications: {}", (Object)project.getKey(), projectEither.left().get());
            projectErrors.add(projectEither.left().get());
        }
        return Eithers.cond((boolean)projectErrors.isEmpty(), projectErrors, (Object)Unit.Unit());
    }

    private List<Project> getServiceDeskProjects() {
        return this.projectManager.getProjects().stream().filter(this::isServiceDeskProject).collect(Collectors.toList());
    }

    private boolean isServiceDeskProject(Project project) {
        return ServiceDeskProjectType.KEY.equals((Object)project.getProjectTypeKey());
    }

    private Either<String, Unit> upgradeProject(Project project) {
        NotificationUpgradeUser upgradeUser = new NotificationUpgradeUser();
        return this.upgradeProject(upgradeUser, project);
    }

    private Either<String, Unit> upgradeProject(ApplicationUser user, Project project) {
        boolean enableRules = !this.globalNotificationsManager.isNotificationDisabled();
        return (Either)this.notificationProjectUpgradeManager.upgradeProject(user, project, enableRules, false).fold(error -> Either.left((Object)error.getMessage().getMessage()), ruleSet -> Either.right((Object)Unit.Unit()));
    }
}

