/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.notifications.internal.dao;

import com.atlassian.servicedesk.plugins.notifications.internal.dao.NotificationBatchQueueEntry;
import io.atlassian.fugue.Option;
import java.util.Date;

public final class NotificationBatchQueueEntryBuilder {
    private Long id;
    private Long projectId;
    private Long issueId;
    private String htmlContent;
    private String textContent;
    private Option<String> context;
    private Date eventTime;
    private Date sentTime;
    private Long recipientId;
    private Long authorId;

    public static NotificationBatchQueueEntryBuilder newBuilder() {
        return new NotificationBatchQueueEntryBuilder();
    }

    private NotificationBatchQueueEntryBuilder() {
    }

    public NotificationBatchQueueEntryBuilder projectId(Long projectId) {
        this.projectId = projectId;
        return this;
    }

    public NotificationBatchQueueEntryBuilder issueId(Long issueId) {
        this.issueId = issueId;
        return this;
    }

    public NotificationBatchQueueEntryBuilder recipientId(Long recipientID) {
        this.recipientId = recipientID;
        return this;
    }

    public NotificationBatchQueueEntryBuilder authorId(Long authorId) {
        this.authorId = authorId;
        return this;
    }

    public NotificationBatchQueueEntryBuilder htmlContent(String htmlContent) {
        this.htmlContent = htmlContent;
        return this;
    }

    public NotificationBatchQueueEntryBuilder textContent(String textContent) {
        this.textContent = textContent;
        return this;
    }

    public NotificationBatchQueueEntryBuilder context(Option<String> context) {
        this.context = context;
        return this;
    }

    public NotificationBatchQueueEntryBuilder eventTime(Date eventTime) {
        this.eventTime = eventTime;
        return this;
    }

    NotificationBatchQueueEntryBuilder sentTime(Date sentTime) {
        this.sentTime = sentTime;
        return this;
    }

    NotificationBatchQueueEntryBuilder id(Long id) {
        this.id = id;
        return this;
    }

    public NotificationBatchQueueEntry build() {
        this.validate();
        return new NotificationBatchQueueEntry((Option<Long>)Option.option((Object)this.id), this.recipientId, (Option<Long>)Option.option((Object)this.authorId), this.projectId, (Option<Long>)Option.option((Object)this.issueId), this.htmlContent, this.textContent, this.context, this.eventTime, (Option<Date>)Option.option((Object)this.sentTime));
    }

    private void validate() {
        if (this.recipientId == null) {
            throw new RuntimeException("no recipient id set");
        }
        if (this.projectId == null) {
            throw new RuntimeException("no project id set");
        }
        if (this.eventTime == null) {
            throw new RuntimeException("no event time set");
        }
        if (this.htmlContent == null) {
            throw new RuntimeException("no html content set");
        }
        if (this.textContent == null) {
            throw new RuntimeException("no text content set");
        }
    }
}

