/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.notifications.internal.dao;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import io.atlassian.fugue.Option;
import java.util.Date;

public class NotificationBatchQueueEntry {
    public static final String CONTEXT_COMMENT = "COMMENT";
    public static final String CONTEXT_REOPEN = "REOPEN";
    public static final String CONTEXT_RESOLVED = "RESOLVED";
    public static final String CONTEXT_STATUS = "STATUS";
    private final Option<Long> id;
    private final long recipientID;
    private final Option<Long> authorId;
    private final long projectId;
    private final Option<Long> issueId;
    private final String htmlContent;
    private final String textContent;
    private final Option<String> context;
    private final Date eventTime;
    private final Option<Date> sentTime;

    NotificationBatchQueueEntry(Option<Long> id, long recipientID, Option<Long> authorId, long projectId, Option<Long> issueId, String htmlContent, String textContent, Option<String> context, Date eventTime, Option<Date> sentTime) {
        this.id = id;
        this.recipientID = recipientID;
        this.authorId = authorId;
        this.projectId = projectId;
        this.issueId = issueId;
        this.htmlContent = htmlContent;
        this.textContent = textContent;
        this.context = context;
        this.eventTime = eventTime;
        this.sentTime = sentTime;
    }

    public long getId() {
        return (Long)this.id.getOrThrow(() -> new UnsupportedOperationException("There is no id when the entry pojo wasn't loaded from database content"));
    }

    public long getRecipientID() {
        return this.recipientID;
    }

    public long getProjectId() {
        return this.projectId;
    }

    public Option<Long> getIssueId() {
        return this.issueId;
    }

    public Option<Long> getAuthorId() {
        return this.authorId;
    }

    public String getHtmlContent() {
        return this.htmlContent;
    }

    public String getTextContent() {
        return this.textContent;
    }

    public Option<String> getContext() {
        return this.context;
    }

    public Date getEventTime() {
        return this.eventTime;
    }

    public Option<Date> getSentTime() {
        return this.sentTime;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", this.id).add("recipientID", this.recipientID).add("authorId", this.authorId).add("projectId", this.projectId).add("issueId", this.issueId).add("htmlContent", (Object)this.htmlContent).add("textContent", (Object)this.textContent).add("context", this.context).add("eventTime", (Object)this.eventTime).add("sentTime", this.sentTime).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NotificationBatchQueueEntry that = (NotificationBatchQueueEntry)o;
        return this.recipientID == that.recipientID && this.projectId == that.projectId && Objects.equal(this.id, that.id) && Objects.equal(this.authorId, that.authorId) && Objects.equal(this.issueId, that.issueId) && Objects.equal((Object)this.htmlContent, (Object)that.htmlContent) && Objects.equal((Object)this.textContent, (Object)that.textContent) && Objects.equal(this.context, that.context) && Objects.equal((Object)this.eventTime, (Object)that.eventTime) && Objects.equal(this.sentTime, that.sentTime);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.id, this.recipientID, this.authorId, this.projectId, this.issueId, this.htmlContent, this.textContent, this.context, this.eventTime, this.sentTime});
    }
}

