/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.notifications.internal.css;

import com.atlassian.botocss.Botocss;
import com.atlassian.botocss.BotocssStyles;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.stereotype.Component;

@Component
public class NotificationsEmailCssLoader {
    private static final Resource STYLESHEET = new ClassPathResource("/servicedesk/internal/notifications/feature/css/custom-notifications.css");
    private final BotocssStyles css = this.loadCss(STYLESHEET);

    public String applyStyles(String html) {
        return Botocss.inject((String)html, (BotocssStyles)this.useCss());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private BotocssStyles loadCss(Resource resource) {
        try (InputStream stream = resource.getInputStream();){
            BotocssStyles botocssStyles = Botocss.parse((String[])new String[]{IOUtils.toString((InputStream)stream, (String)"UTF-8")});
            return botocssStyles;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private BotocssStyles useCss() {
        return this.css;
    }
}

