/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.notifications.internal.configuration;

import com.atlassian.servicedesk.plugins.notifications.internal.configuration.NotificationContext;
import com.atlassian.servicedesk.plugins.notifications.internal.configuration.NotificationVariable;
import io.atlassian.fugue.Option;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public enum StylingVariable implements NotificationVariable
{
    HELP_CENTER_NAME(NotificationContext.NO_CONTEXT, "helpcenter.name", "sd.notifications.variables.styling.help.center.name"),
    MESSAGE_CONTENT(NotificationContext.NO_CONTEXT, "message.content", "sd.notifications.variables.styling.message.content"),
    REQUEST_SHARED_WITH(NotificationContext.ISSUE_CONTEXT, "request.sharedwith", "sd.notifications.variables.styling.request.shared.with"),
    REQUEST_TURN_OFF_NOTIFICATIONS(NotificationContext.ISSUE_CONTEXT, "request.disable.notifications.url", "sd.notifications.variables.styling.turn.off.notifications"),
    JSD_WAC_URL(NotificationContext.NO_CONTEXT, "atlassian.url", "sd.notifications.variables.styling.jsd.wac.url");

    private NotificationContext context;
    private String variable;
    private String nameI18nKey;

    private StylingVariable(NotificationContext context, String variable, String nameI18nKey) {
        this.context = context;
        this.variable = variable;
        this.nameI18nKey = nameI18nKey;
    }

    @Override
    public NotificationContext getContext() {
        return this.context;
    }

    @Override
    public String getVariable() {
        return this.variable;
    }

    @Override
    public String getNameI18nKey() {
        return this.nameI18nKey;
    }

    public static Option<NotificationVariable> forVariable(String variable) {
        return Option.option((Object)StylingVariable.allValuesAsList().stream().filter(stylingVariable -> stylingVariable.getVariable().equals(variable)).findFirst().orElseGet(() -> null));
    }

    private static List<StylingVariable> allValuesAsList() {
        return Collections.unmodifiableList(Arrays.asList(StylingVariable.values()));
    }
}

