/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.notifications.internal.configuration;

import com.atlassian.servicedesk.plugins.notifications.internal.configuration.NotificationContext;
import com.google.common.collect.ImmutableSet;
import io.atlassian.fugue.Option;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public enum NotificationRecipientType {
    REPORTER(NotificationContext.ISSUE_CONTEXT, "reporter", "sd.action.servicedesk.send.notification.recipient.reporter"),
    NEW_PARTICIPANTS(NotificationContext.NEW_PARTICIPANTS_CONTEXT, "new_participants", "sd.action.servicedesk.send.notification.recipient.new.participants"),
    NEW_APPROVERS(NotificationContext.NEW_APPROVERS_CONTEXT, "new_approvers", "sd.action.servicedesk.send.notification.recipient.new.approvers"),
    ALL_CUSTOMERS(NotificationContext.ISSUE_CONTEXT, "all_customers", "sd.action.servicedesk.send.notification.recipient.all.customers"),
    NEW_ORGANISATIONS(NotificationContext.ADDED_ORGANISATION_PARTICIPANTS_CONTEXT, "new_organizations", "sd.action.servicedesk.send.notification.recipient.new.organizations");

    private NotificationContext context;
    private String value;
    private String nameI18nKey;

    private NotificationRecipientType(NotificationContext context, String value, String nameI18nKey) {
        this.context = context;
        this.value = value;
        this.nameI18nKey = nameI18nKey;
    }

    public String getValue() {
        return this.value;
    }

    public NotificationContext getContext() {
        return this.context;
    }

    public String getNameI18nKey() {
        return this.nameI18nKey;
    }

    public static Set<NotificationRecipientType> retrieveAvailableRecipientTypes() {
        return ImmutableSet.copyOf((Object[])NotificationRecipientType.values());
    }

    public static Set<NotificationRecipientType> retrieveAvailableRecipientTypes(Set<NotificationContext> contexts) {
        Set recipientTypes = NotificationRecipientType.asList().stream().filter(recipientType -> contexts.contains((Object)recipientType.context)).collect(Collectors.toSet());
        return Collections.unmodifiableSet(recipientTypes);
    }

    public static Option<NotificationRecipientType> fromString(String storedValue) {
        for (NotificationRecipientType recipientType : NotificationRecipientType.values()) {
            if (!recipientType.getValue().equals(storedValue)) continue;
            return Option.some((Object)((Object)recipientType));
        }
        return Option.none();
    }

    private static List<NotificationRecipientType> asList() {
        return Arrays.asList(NotificationRecipientType.values());
    }
}

