/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.notifications.internal.bootstrap.upgrade.task;

import com.atlassian.fugue.Either;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.api.commons.jira.ErrorResultHelper;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.ConfigurationData;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.IfThen;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.Rule;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.RuleSet;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.RuleSetService;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.ThenActionConfiguration;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.input.RuleSetInput;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.input.RuleSetInputBuilder;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.input.RuleSetInputValidationService;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.validation.ValidatedRuleSet;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.validation.ValidationOutcome;
import com.atlassian.servicedesk.plugins.automation.api.experimental.serviceflags.PermissionCheckFlag;
import com.atlassian.servicedesk.plugins.automation.api.experimental.serviceflags.ServiceFlag;
import com.atlassian.servicedesk.plugins.automation.api.experimental.serviceflags.ServiceFlags;
import com.atlassian.servicedesk.plugins.notifications.internal.bootstrap.upgrade.task.NotificationDefaultRuleBuilderHelper;
import com.atlassian.servicedesk.plugins.notifications.internal.bootstrap.upgrade.task.NotificationDefaultRuleDescriptor;
import io.atlassian.fugue.Option;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class NotificationDefaultRuleManager {
    private final RuleSetInputValidationService ruleSetInputValidationService;
    private final RuleSetService ruleSetService;
    private final ErrorResultHelper errorResultHelper;
    private final NotificationDefaultRuleBuilderHelper notificationDefaultRuleBuilderHelper;

    @Autowired
    public NotificationDefaultRuleManager(RuleSetInputValidationService ruleSetInputValidationService, RuleSetService ruleSetService, ErrorResultHelper errorResultHelper, NotificationDefaultRuleBuilderHelper notificationDefaultRuleBuilderHelper) {
        this.ruleSetInputValidationService = ruleSetInputValidationService;
        this.ruleSetService = ruleSetService;
        this.errorResultHelper = errorResultHelper;
        this.notificationDefaultRuleBuilderHelper = notificationDefaultRuleBuilderHelper;
    }

    public io.atlassian.fugue.Either<AnError, RuleSet> createSystemRule(ApplicationUser ruleCreator, Project project, NotificationDefaultRuleDescriptor descriptor, boolean enableRule) {
        return this.createRuleSetInput(project, descriptor, enableRule).flatMap(ruleSetInput -> StepsConverters.newerEither((Either)this.ruleSetInputValidationService.validate(ruleCreator, ruleSetInput))).flatMap(this::processValidationOutcome).flatMap(validatedRuleSet -> StepsConverters.newerEither((Either)this.ruleSetService.create(ruleCreator, validatedRuleSet, ServiceFlags.of((ServiceFlag[])new ServiceFlag[]{PermissionCheckFlag.SKIP_PERMISSION_CHECK}))));
    }

    public io.atlassian.fugue.Either<AnError, Option<RuleSet>> getSystemRule(Project project, NotificationDefaultRuleDescriptor descriptor) {
        return StepsConverters.newerEither((Either)this.ruleSetService.getActiveRuleSetsByProject(StepsConverters.olderOption((Option)Option.none()), project, ServiceFlags.of((ServiceFlag[])new ServiceFlag[]{PermissionCheckFlag.SKIP_PERMISSION_CHECK}))).map(ruleSets -> this.retrieveRuleSet((List<RuleSet>)ruleSets, descriptor));
    }

    public io.atlassian.fugue.Either<AnError, List<RuleSet>> getAllSystemRules(Project project) {
        return StepsConverters.newerEither((Either)this.ruleSetService.getActiveRuleSetsByProject(StepsConverters.olderOption((Option)Option.none()), project, ServiceFlags.of((ServiceFlag[])new ServiceFlag[]{PermissionCheckFlag.SKIP_PERMISSION_CHECK}))).map(this::retrieveSystemRuleSets);
    }

    private io.atlassian.fugue.Either<AnError, RuleSetInput> createRuleSetInput(Project project, NotificationDefaultRuleDescriptor descriptor, boolean enableRule) {
        if (!descriptor.enableByDefault()) {
            enableRule = false;
        }
        RuleSetInputBuilder builder = this.notificationDefaultRuleBuilderHelper.getBuilder(project, descriptor.getRuleI18nName());
        RuleSetInputBuilder.RuleBuilder ruleBuilder = builder.rule().enabled(enableRule);
        this.notificationDefaultRuleBuilderHelper.addWhenHandler(ruleBuilder, descriptor.getWhenModuleKey());
        io.atlassian.fugue.Either<AnError, ConfigurationData> thenActionConfig = this.notificationDefaultRuleBuilderHelper.buildSendNotificationConfigurationData(descriptor.getRecipients(), project.getId(), descriptor.getContentI18nKey(), descriptor.excludeInitiator());
        if (thenActionConfig.isLeft()) {
            return io.atlassian.fugue.Either.left((Object)thenActionConfig.left().get());
        }
        this.notificationDefaultRuleBuilderHelper.addIfThen(ruleBuilder, descriptor.getIfConditions(), "com.atlassian.servicedesk.servicedesk-notifications-plugin:servicedesk-send-notification-action", (ConfigurationData)thenActionConfig.right().get());
        return io.atlassian.fugue.Either.right((Object)builder.build());
    }

    boolean ruleIsValidNotificationSystemRule(RuleSet ruleSet) {
        return ruleSet.isSystemRuleSet() && ruleSet.getRules().size() == 1 && ((Rule)ruleSet.getRules().get(0)).getIfThens().size() == 1 && ((IfThen)((Rule)ruleSet.getRules().get(0)).getIfThens().get(0)).getThen().getThenActionConfigurations().size() == 1 && ((ThenActionConfiguration)((IfThen)((Rule)ruleSet.getRules().get(0)).getIfThens().get(0)).getThen().getThenActionConfigurations().get(0)).getModuleKey().equals("com.atlassian.servicedesk.servicedesk-notifications-plugin:servicedesk-send-notification-action");
    }

    private io.atlassian.fugue.Either<AnError, ValidatedRuleSet> processValidationOutcome(ValidationOutcome validationOutcome) {
        if (validationOutcome.getRuleSetValidationResult().isPassed()) {
            return io.atlassian.fugue.Either.right((Object)validationOutcome.getValidatedRuleSet().get());
        }
        return io.atlassian.fugue.Either.left((Object)this.errorResultHelper.internalServiceError500("sd.notification.default.rule.validation.error", new Object[0]).build());
    }

    private Option<RuleSet> retrieveRuleSet(List<RuleSet> ruleSets, NotificationDefaultRuleDescriptor descriptor) {
        for (RuleSet ruleSet : ruleSets) {
            if (!this.ruleIsValidNotificationSystemRule(ruleSet) || !ruleSet.getName().equals(descriptor.getRuleI18nName())) continue;
            return Option.option((Object)ruleSet);
        }
        return Option.none();
    }

    private List<RuleSet> retrieveSystemRuleSets(List<RuleSet> ruleSets) {
        ArrayList<RuleSet> systemRuleSets = new ArrayList<RuleSet>();
        for (RuleSet ruleSet : ruleSets) {
            if (!this.ruleIsValidNotificationSystemRule(ruleSet)) continue;
            systemRuleSets.add(ruleSet);
        }
        return systemRuleSets;
    }
}

