/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.notifications.internal.bootstrap.upgrade.task;

import com.atlassian.jira.config.FeatureManager;
import com.atlassian.servicedesk.plugins.notifications.internal.bootstrap.upgrade.task.NotificationDefaultRuleDescriptor;
import com.atlassian.servicedesk.plugins.notifications.internal.bootstrap.upgrade.task.NotificationDefaultRuleIfCondition;
import com.atlassian.servicedesk.plugins.notifications.internal.configuration.NotificationRecipientType;
import com.atlassian.servicedesk.plugins.notifications.internal.simpleui.rule.NotificationRule;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class NotificationDefaultRuleDefaults {
    public static final String SEND_ACTION_LINGO_CATEGORY = "sd.notifications.custom.email.content";
    private static final String RULE_NAME_PREFIX = "sd.notification.default.rule.";
    private static final String RULE_NAME_POSFIX = ".name";
    private static final String COMMENT_ADDED_RULE_TYPE = "comment.added";
    private static final String COMMENT_EDITED_RULE_TYPE = "comment.edited";
    private static final String ISSUE_CREATED_RULE_TYPE = "issue.created";
    private static final String ISSUE_REOPENED_RULE_TYPE = "issue.reopened";
    private static final String ISSUE_RESOLVED_RULE_TYPE = "issue.resolved";
    private static final String PARTICIPANT_ADDED_RULE_TYPE = "request.participant.added";
    private static final String ORGANISATION_ADDED_RULE_TYPE = "request.organisation.added";
    private static final String APPROVAL_REQUIRED_RULE_TYPE = "approval.required";
    private static final String CUSTOMER_VISIBLE_STATUS_CHANGE_RULE_TYPE = "customer.visible.status.change";
    private static final String COMMENT_VISIBILITY_TYPE = "commentType";
    private static final String PUBLIC_VISIBILITY = "public";
    private static final String FIELD_CHANGE_TYPE = "fieldChangeType";
    private static final String SET = "SET";
    private static final String CLEARED = "CLEAR";
    private final FeatureManager featureManager;
    static final NotificationDefaultRuleDescriptor COMMENT_ADDED_RULE = NotificationDefaultRuleDescriptor.newBuilder().ruleI18nName(NotificationDefaultRuleDefaults.createRuleName("comment.added")).whenModuleKey("com.atlassian.servicedesk.plugins.automation.servicedesk-automation-modules-plugin:servicedesk-commented-automation-rule-when-handler").ifCondition(NotificationDefaultRuleIfCondition.newBuilder().moduleKey("com.atlassian.servicedesk.plugins.automation.servicedesk-automation-modules-plugin:sd-comment-visibility-if-condition").data("commentType", "public").build()).excludeInitiator(true).recipients((List<NotificationRecipientType>)ImmutableList.of((Object)((Object)NotificationRecipientType.ALL_CUSTOMERS))).contentI18nKey("sd.notification.default.rule.content.comment.added").analyticsSuffix("comment.added").build();
    static final NotificationDefaultRuleDescriptor COMMENT_EDITED_RULE = NotificationDefaultRuleDescriptor.newBuilder().ruleI18nName(NotificationDefaultRuleDefaults.createRuleName("comment.edited")).whenModuleKey("com.atlassian.servicedesk.plugins.automation.servicedesk-automation-modules-plugin:servicedesk-comment-edited-automation-rule-when-handler").ifCondition(NotificationDefaultRuleIfCondition.newBuilder().moduleKey("com.atlassian.servicedesk.plugins.automation.servicedesk-automation-modules-plugin:sd-comment-visibility-if-condition").data("commentType", "public").build()).excludeInitiator(true).recipients((List<NotificationRecipientType>)ImmutableList.of((Object)((Object)NotificationRecipientType.ALL_CUSTOMERS))).contentI18nKey("sd.notification.default.rule.content.comment.edited").analyticsSuffix("comment.edited").build();
    static final NotificationDefaultRuleDescriptor ISSUE_CREATED_RULE = NotificationDefaultRuleDescriptor.newBuilder().ruleI18nName(NotificationDefaultRuleDefaults.createRuleName("issue.created")).whenModuleKey("com.atlassian.servicedesk.plugins.automation.servicedesk-automation-modules-plugin:issue-created-automation-rule-when-handler").excludeInitiator(false).recipients((List<NotificationRecipientType>)ImmutableList.of((Object)((Object)NotificationRecipientType.ALL_CUSTOMERS))).contentI18nKey("sd.notification.default.rule.content.issue.created").analyticsSuffix("issue.created").build();
    static final NotificationDefaultRuleDescriptor ISSUE_REOPENED_RULE = NotificationDefaultRuleDescriptor.newBuilder().ruleI18nName(NotificationDefaultRuleDefaults.createRuleName("issue.reopened")).whenModuleKey("com.atlassian.servicedesk.plugins.automation.servicedesk-automation-modules-plugin:issue-resolution-changed-automation-rule-when-handler").ifCondition(NotificationDefaultRuleIfCondition.newBuilder().moduleKey("com.atlassian.servicedesk.plugins.automation.servicedesk-automation-modules-plugin:issue-resolution-changed-if-condition").data("fieldChangeType", "CLEAR").build()).excludeInitiator(false).recipients((List<NotificationRecipientType>)ImmutableList.of((Object)((Object)NotificationRecipientType.ALL_CUSTOMERS))).contentI18nKey("sd.notification.default.rule.content.issue.reopened").analyticsSuffix("issue.reopened").build();
    static final NotificationDefaultRuleDescriptor ISSUE_RESOLVED_RULE = NotificationDefaultRuleDescriptor.newBuilder().ruleI18nName(NotificationDefaultRuleDefaults.createRuleName("issue.resolved")).whenModuleKey("com.atlassian.servicedesk.plugins.automation.servicedesk-automation-modules-plugin:issue-resolution-changed-automation-rule-when-handler").ifCondition(NotificationDefaultRuleIfCondition.newBuilder().moduleKey("com.atlassian.servicedesk.plugins.automation.servicedesk-automation-modules-plugin:issue-resolution-changed-if-condition").data("fieldChangeType", "SET").build()).excludeInitiator(false).recipients((List<NotificationRecipientType>)ImmutableList.of((Object)((Object)NotificationRecipientType.ALL_CUSTOMERS), (Object)((Object)NotificationRecipientType.REPORTER))).contentI18nKey("sd.notification.default.rule.content.issue.resolved").analyticsSuffix("issue.resolved").build();
    static final NotificationDefaultRuleDescriptor REQUEST_PARTICIPANT_ADDED_RULE = NotificationDefaultRuleDescriptor.newBuilder().ruleI18nName(NotificationDefaultRuleDefaults.createRuleName("request.participant.added")).whenModuleKey("com.atlassian.servicedesk.plugins.automation.servicedesk-automation-modules-plugin:new-participants-when-handler").excludeInitiator(true).recipients((List<NotificationRecipientType>)ImmutableList.of((Object)((Object)NotificationRecipientType.NEW_PARTICIPANTS))).contentI18nKey("sd.notification.default.rule.content.request.participant.added").analyticsSuffix("request.participant.added").build();
    static final NotificationDefaultRuleDescriptor REQUEST_ORGANISATION_ADDED_RULE = NotificationDefaultRuleDescriptor.newBuilder().ruleI18nName(NotificationDefaultRuleDefaults.createRuleName("request.organisation.added")).whenModuleKey("com.atlassian.servicedesk.plugins.automation.servicedesk-automation-modules-plugin:organisation-added-to-issue-when-handler").excludeInitiator(true).recipients((List<NotificationRecipientType>)ImmutableList.of((Object)((Object)NotificationRecipientType.NEW_ORGANISATIONS))).contentI18nKey("sd.notification.default.rule.content.request.organisation.added").analyticsSuffix("request.organisation.added").build();
    static final NotificationDefaultRuleDescriptor APPROVAL_REQUIRED_RULE = NotificationDefaultRuleDescriptor.newBuilder().ruleI18nName(NotificationDefaultRuleDefaults.createRuleName("approval.required")).whenModuleKey("com.atlassian.servicedesk.plugins.automation.servicedesk-automation-modules-plugin:approval-required-when-handler").excludeInitiator(false).recipients((List<NotificationRecipientType>)ImmutableList.of((Object)((Object)NotificationRecipientType.NEW_APPROVERS))).contentI18nKey("sd.notification.default.rule.content.approval.required").analyticsSuffix("approval.required").build();
    private static final List<String> ORDERED_RULE_I18N_NAMES = NotificationDefaultRuleDefaults.ORDERED_DESCRIPTORS(false).stream().map(NotificationDefaultRuleDescriptor::getRuleI18nName).collect(Collectors.toList());
    private static final Comparator<NotificationRule> DEFAULT_RULE_COMPARATOR = (first, second) -> {
        int firstItemIndex = ORDERED_RULE_I18N_NAMES.indexOf(first.getRuleSetI8nName());
        firstItemIndex = firstItemIndex == -1 ? ORDERED_RULE_I18N_NAMES.size() : firstItemIndex;
        int secondItemIndex = ORDERED_RULE_I18N_NAMES.indexOf(second.getRuleSetI8nName());
        secondItemIndex = secondItemIndex == -1 ? ORDERED_RULE_I18N_NAMES.size() : secondItemIndex;
        return Integer.compare(firstItemIndex, secondItemIndex);
    };
    private static final Comparator<NotificationRule> RULE_NAME_COMPARATOR = (first, second) -> first.getRuleSetName().compareTo(second.getRuleSetName());
    public static final Comparator<NotificationRule> RULE_ORDER_COMPARATOR = DEFAULT_RULE_COMPARATOR.thenComparing(RULE_NAME_COMPARATOR);

    @Autowired
    public NotificationDefaultRuleDefaults(FeatureManager featureManager) {
        this.featureManager = featureManager;
    }

    static NotificationDefaultRuleDescriptor CUSTOMER_VISIBLE_STATUS_CHANGE_RULE(boolean newProject) {
        return NotificationDefaultRuleDescriptor.newBuilder().ruleI18nName(NotificationDefaultRuleDefaults.createRuleName(CUSTOMER_VISIBLE_STATUS_CHANGE_RULE_TYPE)).whenModuleKey("com.atlassian.servicedesk.plugins.automation.servicedesk-automation-modules-plugin:issue-status-transitioned-automation-rule-when-handler").ifCondition(NotificationDefaultRuleIfCondition.newBuilder().moduleKey("com.atlassian.servicedesk.plugins.automation.servicedesk-automation-modules-plugin:customer-visible-status-change-if-condition").build()).excludeInitiator(false).recipients((List<NotificationRecipientType>)ImmutableList.of((Object)((Object)NotificationRecipientType.ALL_CUSTOMERS))).contentI18nKey("sd.notification.default.rule.content.customer.visible.status.change").analyticsSuffix(CUSTOMER_VISIBLE_STATUS_CHANGE_RULE_TYPE).enableByDefault(newProject).build();
    }

    private static List<NotificationDefaultRuleDescriptor> ORDERED_DESCRIPTORS(boolean newProject) {
        return ImmutableList.builder().add((Object)ISSUE_CREATED_RULE).add((Object)COMMENT_ADDED_RULE).add((Object)COMMENT_EDITED_RULE).add((Object)ISSUE_RESOLVED_RULE).add((Object)ISSUE_REOPENED_RULE).add((Object)REQUEST_PARTICIPANT_ADDED_RULE).add((Object)REQUEST_ORGANISATION_ADDED_RULE).add((Object)APPROVAL_REQUIRED_RULE).add((Object)NotificationDefaultRuleDefaults.CUSTOMER_VISIBLE_STATUS_CHANGE_RULE(newProject)).build();
    }

    public String getAnalyticsSuffixFromI18nName(String ruleI18nName) {
        return this.getAllSystemRuleDescriptors(false).stream().filter(descriptor -> descriptor.getRuleI18nName().equals(ruleI18nName)).map(NotificationDefaultRuleDescriptor::getAnalyticsSuffix).findFirst().orElse("");
    }

    public List<NotificationDefaultRuleDescriptor> getAllSystemRuleDescriptors(boolean newProject) {
        ArrayList<NotificationDefaultRuleDescriptor> allSystemRuleDescriptors = new ArrayList<NotificationDefaultRuleDescriptor>(NotificationDefaultRuleDefaults.ORDERED_DESCRIPTORS(newProject));
        if (!this.featureManager.isEnabled("sd.customer.orgs.group.participants")) {
            allSystemRuleDescriptors.remove(REQUEST_ORGANISATION_ADDED_RULE);
        }
        return ImmutableList.copyOf(allSystemRuleDescriptors);
    }

    public NotificationDefaultRuleDescriptor getOrganisationAddedRuleDescriptor() {
        return REQUEST_ORGANISATION_ADDED_RULE;
    }

    private static String createRuleName(String ruleType) {
        return RULE_NAME_PREFIX + ruleType + RULE_NAME_POSFIX;
    }
}

