/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.notifications.internal.bootstrap.upgrade.task;

import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.project.Project;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.api.commons.jira.ErrorResultHelper;
import com.atlassian.pocketknife.step.Steps;
import com.atlassian.servicedesk.internal.api.lingo.manager.LingoManager;
import com.atlassian.servicedesk.internal.api.lingo.request.LingoInput;
import com.atlassian.servicedesk.internal.api.lingo.request.LingoInputBuilderFactory;
import com.atlassian.servicedesk.internal.api.lingo.request.LingoQueryRequestFactory;
import com.atlassian.servicedesk.internal.api.lingo.response.Lingo;
import com.atlassian.servicedesk.internal.api.lingo.response.LingoTranslation;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.ConfigurationData;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.input.BuilderService;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.input.RuleSetInputBuilder;
import com.atlassian.servicedesk.plugins.notifications.internal.bootstrap.upgrade.task.NotificationDefaultRuleIfCondition;
import com.atlassian.servicedesk.plugins.notifications.internal.configuration.NotificationRecipientType;
import com.google.common.collect.ImmutableMap;
import io.atlassian.fugue.Either;
import io.atlassian.fugue.Option;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import org.codehaus.jackson.map.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
class NotificationDefaultRuleBuilderHelper {
    private static final Logger LOG = LoggerFactory.getLogger(NotificationDefaultRuleBuilderHelper.class);
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static final String RECIPIENT_KEY = "recipients";
    private static final String PROJECT_ID_KEY = "projectid";
    private static final String CONTENT_KEY = "content";
    private static final String KEY_DEFAULT_LANGUAGE = "default";
    private static final String EXCLUDE_INITIATOR_KEY = "excludeinitiator";
    private static final String RECIPIENT_TYPE_KEY = "type";
    private static final String IS_DEFAULT_RULE = "isdefaultrule";
    private static final String KEY_LINGO = "lingo";
    private final BuilderService builderService;
    private final ErrorResultHelper errorResultHelper;
    private final LingoInputBuilderFactory lingoInputBuilderFactory;
    private final LingoManager lingoManager;
    private final LingoQueryRequestFactory lingoQueryRequestFactory;
    private final ApplicationProperties applicationProperties;

    @Autowired
    public NotificationDefaultRuleBuilderHelper(BuilderService builderService, ErrorResultHelper errorResultHelper, LingoInputBuilderFactory lingoInputBuilderFactory, LingoManager lingoManager, LingoQueryRequestFactory lingoQueryRequestFactory, ApplicationProperties applicationProperties) {
        this.builderService = builderService;
        this.errorResultHelper = errorResultHelper;
        this.lingoInputBuilderFactory = lingoInputBuilderFactory;
        this.lingoManager = lingoManager;
        this.lingoQueryRequestFactory = lingoQueryRequestFactory;
        this.applicationProperties = applicationProperties;
    }

    RuleSetInputBuilder getBuilder(Project project, String ruleName) {
        return this.builderService.newRuleSetBuilder().name(ruleName).description("").isSystemRuleSet(true).metadata().triggerFromOtherRules(Boolean.valueOf(true)).userContext().runAsCurrentUser().endUserContext().projectContext().project(project).endProjectContext().endMetadata();
    }

    void addWhenHandler(RuleSetInputBuilder.RuleBuilder builder, String moduleKey) {
        builder.when().whenHandler().moduleKey(moduleKey).data(this.builderService.newConfigurationDataBuilder().build());
    }

    Either<AnError, ConfigurationData> buildSendNotificationConfigurationData(List<NotificationRecipientType> recipientTypes, long projectId, String contentI18nKey, boolean excludeInitiator) {
        return Steps.begin(this.buildRecipientString(recipientTypes)).then(recipients -> this.createEmailContentLingo(contentI18nKey, projectId)).then((recipients, contentLingo) -> this.buildContentJsonMap((Lingo)contentLingo)).yield((recipients, contentLingo, contentJsonMap) -> this.builderService.newConfigurationDataBuilder().put(RECIPIENT_KEY, recipients).put(PROJECT_ID_KEY, String.valueOf(projectId)).put(KEY_LINGO, Long.toString(contentLingo.getId())).put(CONTENT_KEY, contentJsonMap).put(EXCLUDE_INITIATOR_KEY, String.valueOf(excludeInitiator)).put(IS_DEFAULT_RULE, String.valueOf(true)).build());
    }

    void addIfThen(RuleSetInputBuilder.RuleBuilder builder, List<NotificationDefaultRuleIfCondition> ifConditions, String thenModuleKey, ConfigurationData thenConfigurationData) {
        RuleSetInputBuilder.IfThenBuilder ifThenBuilder = builder.ifThen();
        this.addIfConditions(ifConditions, ifThenBuilder);
        this.addThenAction(thenModuleKey, thenConfigurationData, ifThenBuilder);
    }

    private void addIfConditions(List<NotificationDefaultRuleIfCondition> ifConditions, RuleSetInputBuilder.IfThenBuilder ifThenBuilder) {
        for (NotificationDefaultRuleIfCondition ifCondition : ifConditions) {
            ifThenBuilder.ruleIf().ifCondition().moduleKey(ifCondition.getModuleKey()).data(this.builderService.newConfigurationDataBuilder().putAll(ifCondition.getData()).build());
        }
    }

    private void addThenAction(String thenModuleKey, ConfigurationData thenConfigurationData, RuleSetInputBuilder.IfThenBuilder ifThenBuilder) {
        ifThenBuilder.ruleThen().thenAction().moduleKey(thenModuleKey).data(thenConfigurationData);
    }

    private Either<AnError, Lingo> createEmailContentLingo(String i18nKey, long projectId) {
        Either lingoInputEither = this.lingoInputBuilderFactory.newBuilder().projectId(Long.valueOf(projectId)).systemI18n(i18nKey).category("sd.notifications.custom.email.content").build();
        return lingoInputEither.flatMap(this::storeLingoInput);
    }

    private Either<AnError, Lingo> storeLingoInput(LingoInput lingoInput) {
        return this.lingoManager.storeLingo(lingoInput).flatMap(this::retrieveLingoById).toRight(() -> this.errorResultHelper.internalServiceError500("sd.notification.default.rule.lingo.store.failed", new Object[]{lingoInput.getSystemI18n().getOrNull()}).build());
    }

    private Option<Lingo> retrieveLingoById(long lingoId) {
        return this.lingoManager.retrieveLingo(this.lingoQueryRequestFactory.createLingoQueryRequest(Long.valueOf(lingoId)));
    }

    private Either<AnError, String> buildContentJsonMap(Lingo lingo) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        Locale siteDefaultLocale = this.applicationProperties.getDefaultLocale();
        for (LingoTranslation translation : lingo.getTranslations()) {
            Locale locale = translation.getLocale();
            builder.put((Object)locale.toLanguageTag(), (Object)translation.getContent());
            if (!locale.equals(siteDefaultLocale)) continue;
            builder.put((Object)KEY_DEFAULT_LANGUAGE, (Object)translation.getContent());
        }
        try {
            return Either.right((Object)OBJECT_MAPPER.writeValueAsString((Object)builder.build()));
        }
        catch (IOException e) {
            LOG.error("Content could not be put into a json object", (Throwable)e);
            return Either.left((Object)this.errorResultHelper.internalServiceError500("sd.notification.default.rule.then.config.content.parsing.error", new Object[0]).build());
        }
    }

    private Either<AnError, String> buildRecipientString(List<NotificationRecipientType> recipientTypes) {
        List recipientTypesInputFormat = recipientTypes.stream().map(recipientType -> ImmutableMap.of((Object)RECIPIENT_TYPE_KEY, (Object)recipientType.getValue())).collect(Collectors.toList());
        try {
            return Either.right((Object)OBJECT_MAPPER.writeValueAsString(recipientTypesInputFormat));
        }
        catch (IOException e) {
            LOG.error("Failed to convert recipient types list into JSON string", (Throwable)e);
            return Either.left((Object)this.errorResultHelper.internalServiceError500("sd.notification.default.rule.then.config.recipient.parsing.error", new Object[0]).build());
        }
    }
}

