/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.notifications.internal.bootstrap.upgrade;

import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.pocketknife.api.persistence.GlobalPropertyDao;
import com.atlassian.servicedesk.internal.api.bootstrap.upgrade.AsyncUpgradeTaskResult;
import com.atlassian.servicedesk.plugins.notifications.internal.defaultrules.migration.NotificationUpgradeTaskManager;
import io.atlassian.fugue.Option;
import java.util.Collection;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@ExportAsService(value={UpgradeTaskCreateDefaultNotificationsRules.class})
public class UpgradeTaskCreateDefaultNotificationsRules {
    public static final String NOTIFICATIONS_UPGRADED_PROPERTY_KEY = "com.atlassian.servicedesk.servicedesk-notifications-plugin.notifications.upgrade.completed";
    private static final Logger LOG = Logger.getLogger(UpgradeTaskCreateDefaultNotificationsRules.class);
    private final NotificationUpgradeTaskManager notificationUpgradeTaskManager;
    private final GlobalPropertyDao globalPropertyDao;

    @Autowired
    public UpgradeTaskCreateDefaultNotificationsRules(NotificationUpgradeTaskManager notificationUpgradeTaskManager, GlobalPropertyDao globalPropertyDao) {
        this.notificationUpgradeTaskManager = notificationUpgradeTaskManager;
        this.globalPropertyDao = globalPropertyDao;
    }

    public AsyncUpgradeTaskResult doUpgrade() {
        if (this.upgradeTaskHasRun()) {
            return AsyncUpgradeTaskResult.success();
        }
        LOG.info((Object)"Starting NotificationsUpgradeAction");
        long startTimeMillis = System.currentTimeMillis();
        return (AsyncUpgradeTaskResult)this.notificationUpgradeTaskManager.upgradeInstance().fold(errors -> {
            String errorList = StringUtils.join((Collection)errors, (String)", ");
            LOG.error((Object)("NotificationsUpgradeAction failed, error list: " + errorList));
            return AsyncUpgradeTaskResult.failure((String)errorList);
        }, success -> {
            this.markUpgradeTaskAsCompleted();
            float executionTimeSeconds = (float)(System.currentTimeMillis() - startTimeMillis) / 1000.0f;
            LOG.info((Object)String.format("Successfully completed NotificationsUpgradeAction after %s seconds", Float.valueOf(executionTimeSeconds)));
            return AsyncUpgradeTaskResult.success();
        });
    }

    private boolean upgradeTaskHasRun() {
        return (Boolean)Option.option((Object)this.globalPropertyDao.getBooleanProperty(NOTIFICATIONS_UPGRADED_PROPERTY_KEY)).getOrElse((Object)false);
    }

    private void markUpgradeTaskAsCompleted() {
        this.globalPropertyDao.setBooleanProperty(NOTIFICATIONS_UPGRADED_PROPERTY_KEY, Boolean.valueOf(true));
    }

    static {
        LOG.setLevel(Level.INFO);
    }
}

