/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.notifications.internal.bootstrap.lifecycle;

import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.event.events.PluginEnabledEvent;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.pocketknife.api.util.runners.SealedRunner;
import com.atlassian.sal.api.lifecycle.LifecycleAware;
import com.atlassian.servicedesk.plugins.notifications.internal.bootstrap.upgrade.UpgradeTaskCreateDefaultNotificationsRules;
import com.atlassian.servicedesk.plugins.notifications.internal.listener.NotificationsProjectEventListener;
import com.atlassian.servicedesk.plugins.notifications.internal.scheduler.NotificationBatchJobRunner;
import com.atlassian.servicedesk.plugins.notifications.internal.scheduler.NotificationBatchScheduler;
import com.atlassian.util.concurrent.LazyReference;
import com.google.common.annotations.VisibleForTesting;
import java.util.Arrays;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@ExportAsService
@Component
public class NotificationsPluginLauncher
implements LifecycleAware {
    private static final Logger log = LoggerFactory.getLogger(NotificationsPluginLauncher.class);
    private static final String SD_PLUGIN_KEY = "com.atlassian.servicedesk";
    private static final String SD_PLUGIN_STARTED_EVENT = "servicedesk.plugin.started.event";
    private static final String PLUGIN_STARTED_EVENT = "plugin.started.event";
    private static final String LIFECYCLE_AWARE_ONSTART = "lifecycle.aware.onstart";
    private final NotificationBatchScheduler notificationBatchScheduler;
    private final EventPublisher eventPublisher;
    private final NotificationsProjectEventListener notificationsProjectEventListener;
    private final NotificationBatchJobRunner notificationBatchJobRunner;
    private final UpgradeTaskCreateDefaultNotificationsRules notificationsUpgradeTask;
    private LazyReference<SealedRunner> sealedStartCompleteRunner = new LazyReference<SealedRunner>(){

        protected SealedRunner create() throws Exception {
            return new SealedRunner(Arrays.asList(NotificationsPluginLauncher.PLUGIN_STARTED_EVENT, NotificationsPluginLauncher.LIFECYCLE_AWARE_ONSTART, NotificationsPluginLauncher.SD_PLUGIN_STARTED_EVENT), () -> NotificationsPluginLauncher.this.onStartCompleted());
        }
    };

    @Autowired
    public NotificationsPluginLauncher(NotificationBatchScheduler notificationBatchScheduler, EventPublisher eventPublisher, NotificationsProjectEventListener notificationsProjectEventListener, NotificationBatchJobRunner notificationBatchJobRunner, UpgradeTaskCreateDefaultNotificationsRules notificationsUpgradeTask) {
        this.notificationBatchScheduler = notificationBatchScheduler;
        this.eventPublisher = eventPublisher;
        this.notificationsProjectEventListener = notificationsProjectEventListener;
        this.notificationBatchJobRunner = notificationBatchJobRunner;
        this.notificationsUpgradeTask = notificationsUpgradeTask;
    }

    @PostConstruct
    public void onSpringContextStarted() {
        this.eventPublisher.register((Object)this);
    }

    @EventListener
    public final void onPluginStarted(PluginEnabledEvent pluginEnabledEvent) {
        String key;
        switch (key = pluginEnabledEvent.getPlugin().getKey()) {
            case "com.atlassian.servicedesk.servicedesk-notifications-plugin": {
                ((SealedRunner)this.sealedStartCompleteRunner.get()).breakSeal(PLUGIN_STARTED_EVENT);
                break;
            }
            case "com.atlassian.servicedesk": {
                ((SealedRunner)this.sealedStartCompleteRunner.get()).breakSeal(SD_PLUGIN_STARTED_EVENT);
            }
        }
    }

    public void onStart() {
        ((SealedRunner)this.sealedStartCompleteRunner.get()).breakSeal(LIFECYCLE_AWARE_ONSTART);
    }

    @VisibleForTesting
    void onStartCompleted() {
        log.info("Service Desk Notifications Plugin starting");
        this.tenantlessSetup();
        this.tenantedSetup();
        log.info("Service Desk Notifications Plugin started");
    }

    private void tenantlessSetup() {
        this.eventPublisher.register((Object)this.notificationsProjectEventListener);
        this.notificationBatchScheduler.register(this.notificationBatchJobRunner);
    }

    private void tenantedSetup() {
        this.notificationsUpgradeTask.doUpgrade();
        this.notificationBatchScheduler.schedule();
    }

    public void onStop() {
        this.tenantedShutDown();
        this.tenantlessShutDown();
        log.info("Service Desk Notifications Plugin stopped");
    }

    private void tenantlessShutDown() {
        this.eventPublisher.unregister((Object)this);
        this.notificationBatchScheduler.unregister();
        this.eventPublisher.unregister((Object)this.notificationsProjectEventListener);
    }

    private void tenantedShutDown() {
        this.notificationBatchScheduler.unschedule();
    }
}

