/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.notifications.internal.automation.then.configuration;

import com.atlassian.annotations.tenancy.TenancyScope;
import com.atlassian.annotations.tenancy.TenantAware;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.api.commons.jira.ErrorResultHelper;
import com.atlassian.servicedesk.internal.api.lingo.response.Lingo;
import com.atlassian.servicedesk.plugins.notifications.internal.automation.then.configuration.NotificationContent;
import com.atlassian.servicedesk.plugins.notifications.internal.recipients.NotificationRecipientConfiguration;
import io.atlassian.fugue.Either;
import io.atlassian.fugue.Option;
import io.atlassian.fugue.Unit;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class SendActionConfiguration {
    private final Long projectId;
    private final Option<Lingo> lingo;
    private final NotificationContent content;
    private final NotificationRecipientConfiguration recipientConfiguration;
    private final boolean defaultRule;

    private SendActionConfiguration(Long projectId, Lingo lingo, NotificationContent content, NotificationRecipientConfiguration recipientConfiguration, boolean defaultRule) {
        this.projectId = projectId;
        this.lingo = Option.option((Object)lingo);
        this.content = content;
        this.recipientConfiguration = recipientConfiguration;
        this.defaultRule = defaultRule;
    }

    public Long getProjectId() {
        return this.projectId;
    }

    public Option<Lingo> getLingo() {
        return this.lingo;
    }

    public NotificationContent getContent() {
        return this.content;
    }

    public NotificationRecipientConfiguration getRecipientConfiguration() {
        return this.recipientConfiguration;
    }

    public boolean isDefaultRule() {
        return this.defaultRule;
    }

    static class Builder {
        private final ErrorResultHelper errorResultHelper;
        private Long projectId;
        private Lingo lingo;
        @TenantAware(value=TenancyScope.TENANTED)
        private final Map<Locale, String> content = new HashMap<Locale, String>();
        private NotificationRecipientConfiguration recipientConfiguration;
        private boolean defaultRule;

        public static Builder newBuilder(ErrorResultHelper errorResultHelper) {
            return new Builder(errorResultHelper);
        }

        private Builder(ErrorResultHelper errorResultHelper) {
            this.errorResultHelper = errorResultHelper;
        }

        Builder lingo(Lingo lingo) {
            this.lingo = lingo;
            return this;
        }

        Builder projectId(Long projectId) {
            this.projectId = projectId;
            return this;
        }

        Builder addContentTranslation(Locale locale, String translation) {
            this.content.put(locale, translation);
            return this;
        }

        Builder recipientConfiguration(NotificationRecipientConfiguration recipientConfiguration) {
            this.recipientConfiguration = recipientConfiguration;
            return this;
        }

        Builder defaultRule(boolean defaultRule) {
            this.defaultRule = defaultRule;
            return this;
        }

        Either<AnError, SendActionConfiguration> build() {
            return this.validate().map(unit -> new SendActionConfiguration(this.projectId, this.lingo, new NotificationContent(Collections.unmodifiableMap(this.content)), this.recipientConfiguration, this.defaultRule));
        }

        private Either<AnError, Unit> validate() {
            if (this.projectId == null) {
                return Either.left((Object)this.errorResultHelper.internalServiceError500("sd.notifications.base.project.id.missing", new Object[0]).build());
            }
            if (this.lingo == null && this.content.isEmpty()) {
                return Either.left((Object)this.errorResultHelper.internalServiceError500("sd.notifications.base.content.missing", new Object[0]).build());
            }
            return Either.right((Object)Unit.Unit());
        }
    }
}

