/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.notifications.internal.automation.then.configuration;

import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.api.commons.jira.ErrorResultHelper;
import com.atlassian.servicedesk.internal.api.lingo.manager.LingoManager;
import com.atlassian.servicedesk.internal.api.lingo.request.LingoQueryRequest;
import com.atlassian.servicedesk.internal.api.lingo.request.LingoQueryRequestFactory;
import com.atlassian.servicedesk.internal.api.lingo.response.Lingo;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.ConfigurationData;
import com.atlassian.servicedesk.plugins.notifications.internal.automation.then.configuration.SendActionConfiguration;
import com.atlassian.servicedesk.plugins.notifications.internal.configuration.NotificationRecipientType;
import com.atlassian.servicedesk.plugins.notifications.internal.recipients.NotificationRecipientConfiguration;
import com.atlassian.servicedesk.plugins.notifications.internal.recipients.NotificationRecipientConfigurationImpl;
import com.google.common.annotations.VisibleForTesting;
import io.atlassian.fugue.Either;
import io.atlassian.fugue.Maybe;
import io.atlassian.fugue.Option;
import io.atlassian.fugue.Unit;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.type.TypeFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ConfigurationHelper {
    private static final Logger LOG = LoggerFactory.getLogger(ConfigurationHelper.class);
    private static final String KEY_CONTENT = "content";
    private static final String KEY_PROJECT_ID = "projectid";
    private static final String KEY_LINGO = "lingo";
    private static final String KEY_RECIPIENTS = "recipients";
    private static final String KEY_EXCLUDE_INITIATOR = "excludeinitiator";
    private static final String KEY_IS_DEFAULT_RULE = "isdefaultrule";
    private static final String KEY_DEFAULT_LANGUAGE = "default";
    private final ErrorResultHelper errorResultHelper;
    private final LingoQueryRequestFactory lingoQueryRequestFactory;
    private final LingoManager lingoManager;
    private final ApplicationProperties applicationProperties;
    private final ObjectMapper objectMapper;

    @Autowired
    public ConfigurationHelper(ErrorResultHelper errorResultHelper, LingoQueryRequestFactory lingoQueryRequestFactory, LingoManager lingoManager, ApplicationProperties applicationProperties) {
        this.errorResultHelper = errorResultHelper;
        this.lingoQueryRequestFactory = lingoQueryRequestFactory;
        this.lingoManager = lingoManager;
        this.applicationProperties = applicationProperties;
        this.objectMapper = new ObjectMapper();
    }

    public Map<String, String> replaceContentInConfiguration(Map<String, String> configurationMap, SendActionConfiguration configuration) {
        return this.replaceContentInConfiguration(configurationMap, this.createContentOutOfConfiguration(configuration));
    }

    public Map<String, String> replaceContentInConfiguration(Map<String, String> configurationMap, Map<String, String> translations) {
        HashMap<String, String> map = new HashMap<String, String>(configurationMap);
        this.convertMapToJSONString(translations).foreach(content -> map.put(KEY_CONTENT, (String)content));
        return Collections.unmodifiableMap(map);
    }

    private Map<String, String> createContentOutOfConfiguration(SendActionConfiguration configuration) {
        Map<Locale, String> languages = configuration.getContent().getContentAsMap();
        return languages.entrySet().stream().collect(Collectors.toMap(entry -> ((Locale)entry.getKey()).toLanguageTag(), Map.Entry::getValue));
    }

    public Map<String, String> addLingoToConfiguration(Map<String, String> configuration, Long lingoId) {
        HashMap<String, String> map = new HashMap<String, String>(configuration);
        map.put(KEY_LINGO, lingoId.toString());
        return Collections.unmodifiableMap(map);
    }

    public Either<AnError, SendActionConfiguration> configurationDataToModel(ConfigurationData configurationData) {
        return this.configurationDataToModel(configurationData.getAll());
    }

    public Option<Long> retrieveProjectId(ConfigurationData configurationData) {
        return this.retrieveProjectId(configurationData.getAll());
    }

    public Either<AnError, SendActionConfiguration> configurationDataToModel(Map<String, String> configurationData) {
        SendActionConfiguration.Builder configurationBuilder = SendActionConfiguration.Builder.newBuilder(this.errorResultHelper).defaultRule(this.isDefaultRule(configurationData));
        this.retrieveProjectId(configurationData).forEach(configurationBuilder::projectId);
        this.retrieveContent(configurationData).forEach(content -> this.addContentToBuilder(configurationBuilder, (String)content));
        this.retrieveLingo(configurationData).forEach(configurationBuilder::lingo);
        return this.retrieveRecipientConfiguration(configurationData).flatMap(recipientConfiguration -> {
            configurationBuilder.recipientConfiguration((NotificationRecipientConfiguration)recipientConfiguration);
            return configurationBuilder.build();
        });
    }

    private Either<AnError, Unit> addContentToBuilder(SendActionConfiguration.Builder builder, String content) {
        return this.parseJSONStringToMap(content).map(contentMap -> {
            if (contentMap.containsKey(KEY_DEFAULT_LANGUAGE)) {
                builder.addContentTranslation(this.retrieveJIRADefaultLocale(), (String)contentMap.get(KEY_DEFAULT_LANGUAGE));
            }
            contentMap.forEach((key, value) -> {
                if (!KEY_DEFAULT_LANGUAGE.equals(key)) {
                    builder.addContentTranslation(Locale.forLanguageTag(key), (String)value);
                }
            });
            return Unit.Unit();
        });
    }

    public Locale retrieveJIRADefaultLocale() {
        return this.applicationProperties.getDefaultLocale();
    }

    public Either<AnError, Option<Long>> retrieveLingoID(Map<String, String> configuration) {
        return this.retrieveLongFromConfiguration(configuration, KEY_LINGO);
    }

    private Option<Lingo> retrieveLingo(Map<String, String> configuration) {
        if (configuration.isEmpty()) {
            return Option.none();
        }
        return ((Option)this.retrieveLingoID(configuration).getOrElse((Object)Option.none())).flatMap(this::retrieveLingo);
    }

    private Option<Lingo> retrieveLingo(Long technicalId) {
        LingoQueryRequest request = this.lingoQueryRequestFactory.createLingoQueryRequest(technicalId);
        return this.lingoManager.retrieveLingo(request);
    }

    public Option<Long> retrieveProjectId(Map<String, String> configuration) {
        Option projectIdOption = (Option)this.retrieveLongFromConfiguration(configuration, KEY_PROJECT_ID).getOrElse((Object)Option.none());
        if (projectIdOption.isEmpty()) {
            LOG.error("Notification send action misconfigured. Project ID not available or invalid format.");
        }
        return projectIdOption;
    }

    private Option<String> retrieveContent(Map<String, String> configuration) {
        return Option.option((Object)configuration.get(KEY_CONTENT));
    }

    private Option<String> retrieveRecipientJSON(Map<String, String> configuration) {
        return Option.option((Object)configuration.get(KEY_RECIPIENTS));
    }

    private boolean extractExcludeInitiator(Map<String, String> configuration) {
        return Boolean.valueOf(configuration.get(KEY_EXCLUDE_INITIATOR));
    }

    private boolean isDefaultRule(Map<String, String> configuration) {
        return Boolean.valueOf(configuration.get(KEY_IS_DEFAULT_RULE));
    }

    private Either<AnError, Option<Long>> retrieveLongFromConfiguration(Map<String, String> configuration, String key) {
        if (configuration.containsKey(key)) {
            String variableValueString = configuration.get(key);
            try {
                return Either.right((Object)Option.some((Object)Long.valueOf(variableValueString)));
            }
            catch (NumberFormatException e) {
                AnError error = this.errorResultHelper.badRequest400("sd.notifications.send.action.spi.long.value.invalid", new Object[]{key, variableValueString}).build();
                LOG.error(error.toString());
                return Either.left((Object)error);
            }
        }
        return Either.right((Object)Option.none());
    }

    @VisibleForTesting
    Either<AnError, NotificationRecipientConfiguration> retrieveRecipientConfiguration(Map<String, String> configurationData) {
        boolean excludeInitiator = this.extractExcludeInitiator(configurationData);
        return this.retrieveRecipientTypes(configurationData).map(recipientTypes -> new NotificationRecipientConfigurationImpl((Set<NotificationRecipientType>)recipientTypes, excludeInitiator));
    }

    private Either<AnError, Set<NotificationRecipientType>> retrieveRecipientTypes(Map<String, String> configuration) {
        return this.retrieveRecipientJSON(configuration).toRight(() -> this.errorResultHelper.internalServiceError500("sd.notifications.base.recipients.missing", new Object[0]).build()).flatMap(this::parseRecipientTypes).flatMap(this::verifyRecipientSet);
    }

    private Either<AnError, Set<NotificationRecipientType>> parseRecipientTypes(String recipientConfigurationJSON) {
        try {
            return Either.right(Arrays.stream((Object[])this.objectMapper.readValue(recipientConfigurationJSON, RecipientConfiguration[].class)).map(configuration -> NotificationRecipientType.fromString(configuration.getType())).filter(Maybe::isDefined).map(Maybe::get).collect(Collectors.toSet()));
        }
        catch (IOException e) {
            LOG.error("Configuration of recipients for the action notification send handler is corrupt", (Throwable)e);
            return Either.left((Object)this.errorResultHelper.internalServiceError500("sd.notifications.base.recipients.read.internal.error", new Object[0]).build());
        }
    }

    private Either<AnError, Map<String, String>> parseJSONStringToMap(String jsonString) {
        try {
            return Either.right((Object)this.objectMapper.readValue(jsonString, TypeFactory.mapType(HashMap.class, String.class, String.class)));
        }
        catch (IOException e) {
            LOG.error("configuration of field 'content' in then action notification send handler is corrupt", (Throwable)e);
            return Either.left((Object)this.errorResultHelper.internalServiceError500("sd.notifications.base.content.format.invalid", new Object[0]).build());
        }
    }

    private Either<AnError, Set<NotificationRecipientType>> verifyRecipientSet(Set<NotificationRecipientType> notificationRecipients) {
        if (notificationRecipients.isEmpty()) {
            LOG.error("List of recipient types was found to be empty");
            return Either.left((Object)this.errorResultHelper.internalServiceError500("sd.notifications.base.recipient.types.empty", new Object[0]).build());
        }
        return Either.right(notificationRecipients);
    }

    private Either<AnError, String> convertMapToJSONString(Map<String, String> map) {
        try {
            return Either.right((Object)this.objectMapper.writeValueAsString(map));
        }
        catch (IOException e) {
            LOG.error("the given map couldn't be transformed to a JSON string", (Throwable)e);
            return Either.left((Object)this.errorResultHelper.internalServiceError500("sd.notifications.base.convert.map.to.json.error", new Object[0]).build());
        }
    }

    @JsonAutoDetect
    private static class RecipientConfiguration {
        private String type;

        private RecipientConfiguration() {
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }
    }
}

