/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.notifications.internal.automation.then;

import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.api.commons.jira.ErrorResultHelper;
import com.atlassian.pocketknife.step.Steps;
import com.atlassian.servicedesk.internal.api.lingo.languageresolution.LingoLanguageResolutionManager;
import com.atlassian.servicedesk.internal.api.lingo.response.Lingo;
import com.atlassian.servicedesk.internal.api.lingo.response.LingoTranslation;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.ConfigurationData;
import com.atlassian.servicedesk.plugins.automation.api.execution.message.RuleMessage;
import com.atlassian.servicedesk.plugins.notifications.internal.analytics.NotificationAnalyticsEventHelper;
import com.atlassian.servicedesk.plugins.notifications.internal.automation.then.MessageHelper;
import com.atlassian.servicedesk.plugins.notifications.internal.automation.then.configuration.ConfigurationHelper;
import com.atlassian.servicedesk.plugins.notifications.internal.automation.then.configuration.SendActionConfiguration;
import com.atlassian.servicedesk.plugins.notifications.internal.message.NotificationMessage;
import com.atlassian.servicedesk.plugins.notifications.internal.message.NotificationMessageBuilder;
import com.atlassian.servicedesk.plugins.notifications.internal.message.RecipientNotificationMessage;
import com.atlassian.servicedesk.plugins.notifications.internal.recipients.RecipientConfigurationManager;
import io.atlassian.fugue.Either;
import io.atlassian.fugue.Option;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
class SendActionHelper {
    private static final Logger LOG = LoggerFactory.getLogger(SendActionHelper.class);
    private final ErrorResultHelper errorResultHelper;
    private final RecipientConfigurationManager recipientConfigurationManager;
    private final ProjectManager projectManager;
    private final NotificationAnalyticsEventHelper notificationAnalyticsEventHelper;
    private final MessageHelper sendNotificationMessageHelper;
    private final ConfigurationHelper configurationHelper;
    private final LingoLanguageResolutionManager lingoLanguageResolutionManager;
    private final ApplicationProperties applicationProperties;

    @Autowired
    public SendActionHelper(ErrorResultHelper errorResultHelper, RecipientConfigurationManager recipientConfigurationManager, ProjectManager projectManager, NotificationAnalyticsEventHelper notificationAnalyticsEventHelper, MessageHelper sendNotificationMessageHelper, ConfigurationHelper configurationHelper, LingoLanguageResolutionManager lingoLanguageResolutionManager, ApplicationProperties applicationProperties) {
        this.errorResultHelper = errorResultHelper;
        this.recipientConfigurationManager = recipientConfigurationManager;
        this.projectManager = projectManager;
        this.notificationAnalyticsEventHelper = notificationAnalyticsEventHelper;
        this.sendNotificationMessageHelper = sendNotificationMessageHelper;
        this.configurationHelper = configurationHelper;
        this.lingoLanguageResolutionManager = lingoLanguageResolutionManager;
        this.applicationProperties = applicationProperties;
    }

    Either<AnError, List<RecipientNotificationMessage>> createNotificationMessages(RuleMessage ruleMessage, ConfigurationData configurationData) {
        return Steps.begin(this.configurationHelper.configurationDataToModel(configurationData)).then(sendActionConfiguration -> this.buildNotificationMessage(ruleMessage, (SendActionConfiguration)sendActionConfiguration)).then((sendActionConfiguration, notificationMessage) -> this.recipientConfigurationManager.getMessageRecipients((NotificationMessage)notificationMessage, sendActionConfiguration.getRecipientConfiguration())).yield(this::internalCreateNotificationMessages).leftMap(error -> this.fireProcessingErrorAnalyticsEvent(configurationData, (AnError)error));
    }

    private AnError fireProcessingErrorAnalyticsEvent(ConfigurationData configurationData, AnError error) {
        this.notificationAnalyticsEventHelper.fireAnalyticsEvent("servicedesk.custom.notifications.dispatch.processing.error", (Long)this.configurationHelper.retrieveProjectId(configurationData).getOrNull());
        return error;
    }

    private List<RecipientNotificationMessage> internalCreateNotificationMessages(SendActionConfiguration sendActionConfiguration, NotificationMessage notificationMessage, Set<ApplicationUser> recipients) {
        this.notificationAnalyticsEventHelper.fireMessagePreparedEvent(sendActionConfiguration.getProjectId(), recipients.size());
        return recipients.stream().map(recipient -> this.createRecipientNotificationMessage(sendActionConfiguration, notificationMessage, (ApplicationUser)recipient)).filter(Either::isRight).map(Either::getOrNull).collect(Collectors.toList());
    }

    private Either<AnError, RecipientNotificationMessage> createRecipientNotificationMessage(SendActionConfiguration sendActionConfiguration, NotificationMessage notificationMessage, ApplicationUser recipient) {
        return this.retrieveTranslation(sendActionConfiguration, notificationMessage, recipient).map(translation -> new RecipientNotificationMessage(recipient, (LingoTranslation)translation, notificationMessage));
    }

    private Either<AnError, LingoTranslation> retrieveTranslation(SendActionConfiguration sendActionConfiguration, NotificationMessage notificationMessage, ApplicationUser recipient) {
        return (Either)notificationMessage.getLingo().fold(() -> Either.right((Object)notificationMessage.getLegacyTranslation().get()), lingo -> this.retrieveUserTranslation((Lingo)lingo, sendActionConfiguration.getProjectId(), recipient));
    }

    private Either<AnError, LingoTranslation> retrieveUserTranslation(Lingo lingo, Long projectId, ApplicationUser applicationUser) {
        Option translationOption = this.lingoLanguageResolutionManager.resolveTranslationForUser(lingo, applicationUser);
        this.logNonDefaultTranslation(projectId, applicationUser, (Option<LingoTranslation>)translationOption);
        return translationOption.toRight(() -> {
            AnError error = this.errorResultHelper.badRequest400("sd.notifications.base.recipient.translation.not.available", new Object[0]).build();
            LOG.error(error.getMessage().getMessage());
            return error;
        });
    }

    private void logNonDefaultTranslation(Long projectId, ApplicationUser applicationUser, Option<LingoTranslation> translationOption) {
        LingoTranslation translation;
        if (translationOption.isDefined() && !this.lingoLanguageResolutionManager.isDefaultTranslation(translation = (LingoTranslation)translationOption.get(), Option.some((Object)projectId))) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Resolved '{}' as translation to use for '{}'.", (Object)translation.getLocale().toLanguageTag(), (Object)applicationUser.getEmailAddress());
            }
            this.notificationAnalyticsEventHelper.fireAnalyticsEvent("servicedesk.custom.notifications.content.language.non.default." + translation.getLocale().toLanguageTag(), projectId);
        }
    }

    private LingoTranslation createTranslationOutOfDefaultContent(SendActionConfiguration sendActionConfiguration) {
        Locale defaultLocale = this.applicationProperties.getDefaultLocale();
        Set<Map.Entry<Locale, String>> entrySet = sendActionConfiguration.getContent().getContentAsMap().entrySet();
        Map.Entry<Locale, String> defaultTranslation = entrySet.stream().filter(entry -> Objects.equals(defaultLocale, entry.getKey())).findFirst().orElse(entrySet.iterator().next());
        Locale locale = defaultTranslation.getKey();
        String content = defaultTranslation.getValue();
        return new DefaultLingoTranslation(locale.getLanguage(), locale, content);
    }

    private Either<AnError, NotificationMessage> buildNotificationMessage(RuleMessage ruleMessage, SendActionConfiguration configuration) {
        NotificationMessageBuilder builder = NotificationMessageBuilder.newBuilder();
        this.sendNotificationMessageHelper.addAvailableContexts(builder, ruleMessage);
        return Steps.begin(this.getProject(configuration.getProjectId())).yield(project -> {
            if (configuration.getLingo().isEmpty()) {
                this.notificationAnalyticsEventHelper.fireAnalyticsEvent("servicedesk.custom.notifications.configuration.lingo.missing", configuration.getProjectId());
                builder.legacyTranslation(this.createTranslationOutOfDefaultContent(configuration));
            } else {
                builder.lingo((Lingo)configuration.getLingo().get());
            }
            return builder.project((Project)project).build();
        });
    }

    private Either<AnError, Project> getProject(Long projectId) {
        return Option.option((Object)this.projectManager.getProjectObj(projectId)).toRight(() -> this.errorResultHelper.internalServiceError500("sd.notifications.base.project.missing", new Object[0]).build());
    }

    private static class DefaultLingoTranslation
    implements LingoTranslation {
        private final String language;
        private final Locale locale;
        private final String content;
        private final boolean activeTranslation;
        private final boolean systemDefaultTranslation;

        private DefaultLingoTranslation(String language, Locale locale, String content) {
            this.language = language;
            this.locale = locale;
            this.content = content;
            this.activeTranslation = true;
            this.systemDefaultTranslation = false;
        }

        public String getLanguage() {
            return this.language;
        }

        public Locale getLocale() {
            return this.locale;
        }

        public String getContent() {
            return this.content;
        }

        public boolean isEnabledTranslation() {
            return this.activeTranslation;
        }

        public boolean isSystemDefaultTranslation() {
            return this.systemDefaultTranslation;
        }
    }
}

