/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.lingo.internal.response;

import com.atlassian.servicedesk.internal.api.lingo.response.LingoTranslation;
import com.google.common.base.MoreObjects;
import io.atlassian.fugue.Option;
import java.util.Locale;
import java.util.Objects;
import java.util.function.Supplier;

public class LingoTranslationImpl
implements LingoTranslation {
    private final String language;
    private final Locale locale;
    private final boolean activeTranslation;
    private Option<String> contentOpt;
    private final boolean systemDefaultTranslation;
    private final Option<Supplier<String>> defaultValueProviderOpt;

    public LingoTranslationImpl(String language, Locale locale, String content, boolean activeTranslation, boolean systemDefaultTranslation) {
        this.language = language;
        this.locale = locale;
        this.contentOpt = Option.some((Object)content);
        this.systemDefaultTranslation = systemDefaultTranslation;
        this.activeTranslation = activeTranslation;
        this.defaultValueProviderOpt = Option.none();
    }

    public LingoTranslationImpl(String language, Locale locale, Supplier<String> defaultValueProvider, boolean activeTranslation, boolean systemDefaultTranslation) {
        this.language = language;
        this.locale = locale;
        this.contentOpt = Option.none();
        this.systemDefaultTranslation = systemDefaultTranslation;
        this.activeTranslation = activeTranslation;
        this.defaultValueProviderOpt = Option.some(defaultValueProvider);
    }

    public String getLanguage() {
        return this.language;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public String getContent() {
        if (this.contentOpt.isEmpty()) {
            String resolvedDefault = (String)((Supplier)this.defaultValueProviderOpt.get()).get();
            this.contentOpt = Option.some((Object)resolvedDefault);
            return resolvedDefault;
        }
        return (String)this.contentOpt.get();
    }

    public boolean isEnabledTranslation() {
        return this.activeTranslation;
    }

    public boolean isSystemDefaultTranslation() {
        return this.systemDefaultTranslation;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LingoTranslationImpl that = (LingoTranslationImpl)o;
        return this.activeTranslation == that.activeTranslation && this.systemDefaultTranslation == that.systemDefaultTranslation && Objects.equals(this.language, that.language) && Objects.equals(this.locale, that.locale) && this.getContent().equals(that.getContent());
    }

    public int hashCode() {
        return Objects.hash(this.language, this.locale, this.activeTranslation, this.systemDefaultTranslation);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("language", (Object)this.language).add("locale", (Object)this.locale).add("activeTranslation", this.activeTranslation).add("content", this.contentOpt).add("systemDefaultTranslation", this.systemDefaultTranslation).toString();
    }
}

