/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.lingo.internal.request;

import com.atlassian.annotations.tenancy.TenancyScope;
import com.atlassian.annotations.tenancy.TenantAware;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.api.commons.error.HttpStatusCode;
import com.atlassian.pocketknife.api.commons.jira.ErrorResultHelper;
import com.atlassian.servicedesk.internal.api.lingo.request.LingoInput;
import com.atlassian.servicedesk.internal.api.lingo.request.LingoInputBuilder;
import com.atlassian.servicedesk.internal.api.lingo.request.LingoTranslationInput;
import com.atlassian.servicedesk.plugins.lingo.internal.request.LingoInputImpl;
import com.atlassian.servicedesk.plugins.lingo.internal.request.LingoTranslationInputImpl;
import io.atlassian.fugue.Either;
import io.atlassian.fugue.Option;
import io.atlassian.fugue.Unit;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

class LingoInputBuilderImpl
implements LingoInputBuilder {
    private final ErrorResultHelper errorResultHelper;
    private Long technicalId;
    private String logicalId;
    private String category;
    private String systemI18n;
    private Option<Long> projectId;
    @TenantAware(value=TenancyScope.TENANTED)
    private Map<Locale, String> translations = new HashMap<Locale, String>();

    LingoInputBuilderImpl(ErrorResultHelper errorResultHelper) {
        this.errorResultHelper = errorResultHelper;
    }

    LingoInputBuilderImpl(ErrorResultHelper errorResultHelper, Long technicalId) {
        this.errorResultHelper = errorResultHelper;
        this.technicalId = technicalId;
    }

    LingoInputBuilderImpl(ErrorResultHelper errorResultHelper, String logicalId) {
        this.errorResultHelper = errorResultHelper;
        this.logicalId = logicalId;
    }

    public LingoInputBuilder category(String category) {
        this.category = category;
        return this;
    }

    public LingoInputBuilder systemI18n(String systemI18n) {
        this.systemI18n = systemI18n;
        return this;
    }

    public LingoInputBuilder addTranslation(Locale locale, String content) {
        this.translations.put(locale, content);
        return this;
    }

    public LingoInputBuilder projectId(@Nonnull Long projectId) {
        this.projectId = Option.some((Object)projectId);
        return this;
    }

    public LingoInputBuilder instanceWideLingo() {
        this.projectId = Option.none();
        return this;
    }

    public Either<AnError, LingoInput> build() {
        return this.validate().map(validationResult -> new LingoInputImpl(this.technicalId, this.logicalId, this.category, this.systemI18n, (Long)this.projectId.getOrNull(), this.createTranslations()));
    }

    private Either<AnError, Unit> validate() {
        if (this.projectId == null) {
            return Either.left((Object)this.errorResultHelper.anError(HttpStatusCode.BAD_REQUEST, "sd.lingo.request.builder.missing.project.context", new Object[0]));
        }
        return Either.right((Object)Unit.Unit());
    }

    private List<LingoTranslationInput> createTranslations() {
        return Collections.unmodifiableList(this.translations.keySet().stream().map(locale -> new LingoTranslationInputImpl((Locale)locale, this.translations.get(locale))).collect(Collectors.toList()));
    }
}

