/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.lingo.internal.project;

import com.atlassian.annotations.nonnull.ReturnValuesAreNonnullByDefault;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.config.LocaleManager;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.pocketknife.api.querydsl.DatabaseAccessor;
import com.atlassian.pocketknife.api.querydsl.DatabaseConnection;
import com.atlassian.servicedesk.internal.api.lingo.project.LingoProjectConfiguration;
import com.atlassian.servicedesk.internal.api.lingo.project.LingoProjectLanguage;
import com.atlassian.servicedesk.internal.api.lingo.project.LingoProjectLanguageInput;
import com.atlassian.servicedesk.internal.api.lingo.project.LingoProjectLanguageManager;
import com.atlassian.servicedesk.plugins.lingo.internal.dao.LingoProjectLanguageQStore;
import com.atlassian.servicedesk.plugins.lingo.internal.manager.LingoPortugueseLocaleCompatibilityManager;
import com.atlassian.servicedesk.plugins.lingo.internal.project.LingoProjectConfigurationImpl;
import com.atlassian.servicedesk.plugins.lingo.internal.project.LingoProjectLanguageImpl;
import com.atlassian.servicedesk.plugins.lingo.internal.util.LingoUtil;
import com.atlassian.vcache.RequestCache;
import com.atlassian.vcache.VCacheFactory;
import io.atlassian.fugue.Option;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@ExportAsService
@ParametersAreNonnullByDefault
@ReturnValuesAreNonnullByDefault
class LingoProjectLanguageManagerImpl
implements LingoProjectLanguageManager {
    private final ApplicationProperties applicationProperties;
    private final LocaleManager localeManager;
    private final I18nHelper i18nHelper;
    private final LingoProjectLanguageQStore lingoProjectLanguageStore;
    private final DatabaseAccessor databaseAccessor;
    private final FeatureManager featureManager;
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final RequestCache<Long, Set<LingoProjectLanguage>> projectLanguageCache;
    private final RequestCache<Long, Locale> defaultLanguageCache;
    private final LingoPortugueseLocaleCompatibilityManager lingoPortugueseLocaleCompatibilityManager;

    @Autowired
    public LingoProjectLanguageManagerImpl(ApplicationProperties applicationProperties, LocaleManager localeManager, I18nHelper i18nHelper, LingoProjectLanguageQStore lingoProjectLanguageStore, DatabaseAccessor databaseAccessor, FeatureManager featureManager, JiraAuthenticationContext jiraAuthenticationContext, VCacheFactory vCacheFactory, LingoPortugueseLocaleCompatibilityManager lingoPortugueseLocaleCompatibilityManager) {
        this.applicationProperties = applicationProperties;
        this.localeManager = localeManager;
        this.i18nHelper = i18nHelper;
        this.lingoProjectLanguageStore = lingoProjectLanguageStore;
        this.databaseAccessor = databaseAccessor;
        this.featureManager = featureManager;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.projectLanguageCache = vCacheFactory.getRequestCache(LingoProjectLanguageManagerImpl.class.getName() + ".lingoProjectLanguageCache");
        this.defaultLanguageCache = vCacheFactory.getRequestCache(LingoProjectLanguageManagerImpl.class.getName() + ".lingoProjectDefaultLanguageCache");
        this.lingoPortugueseLocaleCompatibilityManager = lingoPortugueseLocaleCompatibilityManager;
    }

    public Locale retrieveDefaultLocale(Option<Long> projectId) {
        Set<LingoProjectLanguage> projectLanguages = this.retrieveProjectLanguagesInternal(projectId);
        return this.retrieveDefaultLocaleInternal(projectId, projectLanguages);
    }

    public Set<Locale> retrieveProjectLocales(Long projectId, boolean includeDisabled) {
        return this.retrieveProjectLanguagesInternal((Option<Long>)Option.some((Object)projectId)).stream().filter(language -> includeDisabled || language.isActive()).map(LingoProjectLanguage::getLocale).collect(Collectors.toSet());
    }

    public boolean isCustomLanguageSetting(long projectId) {
        return ((Option)this.databaseAccessor.run(connection -> this.lingoProjectLanguageStore.retrieveProjectLanguageConfigId((DatabaseConnection)connection, projectId))).isDefined();
    }

    public Option<LingoProjectConfiguration> storeProjectLanguages(LingoProjectLanguageInput input) {
        if (input.getLanguages().isEmpty()) {
            return Option.none();
        }
        String authorKey = this.retrieveAuthorKey();
        this.projectLanguageCache.remove((Object)input.getProjectId());
        this.defaultLanguageCache.remove((Object)input.getProjectId());
        this.databaseAccessor.run(connection -> (Long)this.lingoProjectLanguageStore.retrieveProjectLanguageConfigId((DatabaseConnection)connection, input.getProjectId()).fold(() -> this.lingoProjectLanguageStore.insertProjectLanguageConfig((DatabaseConnection)connection, authorKey, input), configId -> this.lingoProjectLanguageStore.updateProjectLanguageConfig((DatabaseConnection)connection, (Long)configId, authorKey, input)));
        return Option.some((Object)this.retrieveLingoProjectConfiguration(input.getProjectId()));
    }

    public boolean isEnabled(Locale locale, Option<Long> projectIdOption) {
        return (Boolean)projectIdOption.fold(() -> this.isActiveInstanceLocale(locale), projectId -> this.isActiveProjectLocale(locale, (Long)projectId));
    }

    private boolean isActiveInstanceLocale(Locale locale) {
        return this.buildDefaultProjectLanguageSet().stream().map(LingoProjectLanguage::getLocale).anyMatch(instanceLocale -> Objects.equals(locale, instanceLocale));
    }

    private boolean isActiveProjectLocale(Locale locale, Long projectId) {
        return this.retrieveProjectLocales(projectId, false).contains(locale);
    }

    @Nonnull
    public LingoProjectConfiguration retrieveLingoProjectConfiguration(long projectId) {
        Set<LingoProjectLanguage> projectLanguages = this.retrieveProjectLanguagesInternal((Option<Long>)Option.some((Object)projectId));
        return new LingoProjectConfigurationImpl(projectId, this.retrieveDefaultLocaleInternal((Option<Long>)Option.some((Object)projectId), projectLanguages), projectLanguages);
    }

    @Nonnull
    public String formatDisplayName(LingoProjectLanguage language, LingoProjectConfiguration configuration) {
        Locale locale = language.getLocale();
        Locale defaultLocale = configuration.getProjectDefaultLocale();
        String displayName = locale.getDisplayName(this.i18nHelper.getLocale());
        if (Objects.equals(defaultLocale, locale)) {
            return this.i18nHelper.getText("admin.common.phrases.default.locale", displayName);
        }
        return displayName;
    }

    private Locale retrieveDefaultLocaleInternal(Option<Long> projectIdOpt, Set<LingoProjectLanguage> projectLanguages) {
        return (Locale)projectIdOpt.fold(() -> this.determineDefaultLocaleBaseOnInstanceDefaultLocale(projectLanguages), projectId -> this.defaultLanguageCache.get(projectId).orElseGet(() -> this.retrieveStoredDefaultLocale((Long)projectId, projectLanguages)));
    }

    private Locale retrieveStoredDefaultLocale(Long projectId, Set<LingoProjectLanguage> projectLanguages) {
        Locale projectDefaultLocale = (Locale)((Option)this.databaseAccessor.run(connection -> this.lingoProjectLanguageStore.retrieveProjectDefaultLanguage((DatabaseConnection)connection, projectId))).getOr(() -> this.determineDefaultLocaleBaseOnInstanceDefaultLocale(projectLanguages));
        this.defaultLanguageCache.put((Object)projectId, (Object)projectDefaultLocale);
        return projectDefaultLocale;
    }

    private Locale determineDefaultLocaleBaseOnInstanceDefaultLocale(Set<LingoProjectLanguage> projectLanguages) {
        Locale siteDefaultLocale = this.applicationProperties.getDefaultLocale();
        Set activeProjectLocales = projectLanguages.stream().filter(LingoProjectLanguage::isActive).map(LingoProjectLanguage::getLocale).collect(Collectors.toSet());
        if (activeProjectLocales.contains(siteDefaultLocale)) {
            return siteDefaultLocale;
        }
        return activeProjectLocales.stream().sorted(LingoUtil.DEFAULT_LOCALE_COMPARATOR).findFirst().get();
    }

    private Set<LingoProjectLanguage> retrieveProjectLanguagesInternal(Option<Long> projectIdOption) {
        if (!this.isManageLanguageFeatureEnabled()) {
            return this.buildDefaultProjectLanguageSet();
        }
        Set projectLanguages = (Set)projectIdOption.fold(this::buildDefaultProjectLanguageSet, projectId -> {
            Optional cachedValue = this.projectLanguageCache.get(projectId);
            return cachedValue.orElseGet(() -> this.retrieveStoredProjectLanguagesFromDatabase((long)projectId));
        });
        return this.lingoPortugueseLocaleCompatibilityManager.applyTransformation(projectLanguages);
    }

    private Set<LingoProjectLanguage> retrieveStoredProjectLanguagesFromDatabase(long projectId) {
        Option storedProjectLanguages = (Option)this.databaseAccessor.run(connection -> this.lingoProjectLanguageStore.retrieveProjectLanguages((DatabaseConnection)connection, projectId));
        Set languages = (Set)storedProjectLanguages.getOr(this::buildDefaultProjectLanguageSet);
        this.projectLanguageCache.put((Object)projectId, (Object)languages);
        return languages;
    }

    private boolean isManageLanguageFeatureEnabled() {
        return (Boolean)this.featureManager.getFeatureFlag("sd.custom.email.notifications.manage.language").map(arg_0 -> ((FeatureManager)this.featureManager).isEnabled(arg_0)).getOrElse((Object)false);
    }

    private Set<LingoProjectLanguage> buildDefaultProjectLanguageSet() {
        return this.localeManager.getInstalledLocales().stream().map(locale -> new LingoProjectLanguageImpl((Locale)locale, true)).collect(Collectors.toSet());
    }

    private String retrieveAuthorKey() {
        return (String)Option.option((Object)this.jiraAuthenticationContext.getLoggedInUser()).map(ApplicationUser::getUsername).getOrElse((Object)"__anonymous__");
    }
}

