/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.lingo.internal.project;

import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.api.commons.error.HttpStatusCode;
import com.atlassian.pocketknife.api.commons.jira.ErrorResultHelper;
import com.atlassian.servicedesk.internal.api.lingo.project.LingoProjectLanguage;
import com.atlassian.servicedesk.internal.api.lingo.project.LingoProjectLanguageInput;
import com.atlassian.servicedesk.internal.api.lingo.project.LingoProjectLanguageInputBuilder;
import com.atlassian.servicedesk.plugins.lingo.internal.project.LingoProjectLanguageImpl;
import com.atlassian.servicedesk.plugins.lingo.internal.project.LingoProjectLanguageInputImpl;
import io.atlassian.fugue.Either;
import io.atlassian.fugue.Option;
import io.atlassian.fugue.Unit;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

class LingoProjectLanguageInputBuilderImpl
implements LingoProjectLanguageInputBuilder {
    private final ErrorResultHelper errorResultHelper;
    private final long projectId;
    private final Map<Locale, Boolean> languagesWithEnabledStates;
    private Option<Locale> defaultLanguage = Option.none();

    LingoProjectLanguageInputBuilderImpl(ErrorResultHelper errorResultHelper, long projectId) {
        this.projectId = projectId;
        this.errorResultHelper = errorResultHelper;
        this.languagesWithEnabledStates = new HashMap<Locale, Boolean>();
    }

    public LingoProjectLanguageInputBuilder addLanguage(Locale locale, boolean active) {
        this.languagesWithEnabledStates.put(locale, active);
        return this;
    }

    public LingoProjectLanguageInputBuilder defaultLanguage(Locale defaultLanguage) {
        this.defaultLanguage = Option.some((Object)defaultLanguage);
        return this;
    }

    public Either<AnError, LingoProjectLanguageInput> build() {
        return this.validate().map(unit -> new LingoProjectLanguageInputImpl(this.projectId, this.languageStatesMapAsLingoProjectLanguageSet(), (Locale)this.defaultLanguage.get()));
    }

    private Set<LingoProjectLanguage> languageStatesMapAsLingoProjectLanguageSet() {
        return this.languagesWithEnabledStates.entrySet().stream().map(entry -> new LingoProjectLanguageImpl((Locale)entry.getKey(), (Boolean)entry.getValue())).collect(Collectors.toSet());
    }

    private Either<AnError, Unit> validate() {
        if (this.languagesWithEnabledStates.isEmpty()) {
            return Either.left((Object)this.errorResultHelper.anError(HttpStatusCode.BAD_REQUEST, "sd.lingo.project.language.missing.languages", new Object[0]));
        }
        if (!this.containsAtLeastOneEnabledLanguage()) {
            return Either.left((Object)this.errorResultHelper.anError(HttpStatusCode.BAD_REQUEST, "sd.lingo.project.language.missing.an.enabled.language", new Object[0]));
        }
        if (this.defaultLanguage.isEmpty() || !this.isLanguageActive((Locale)this.defaultLanguage.get())) {
            return Either.left((Object)this.errorResultHelper.anError(HttpStatusCode.BAD_REQUEST, "sd.lingo.project.language.default.language.invalid", new Object[0]));
        }
        return Either.right((Object)Unit.Unit());
    }

    private boolean isLanguageActive(Locale locale) {
        return this.languagesWithEnabledStates.containsKey(this.defaultLanguage.get()) && this.languagesWithEnabledStates.get(locale) != false;
    }

    private boolean containsAtLeastOneEnabledLanguage() {
        return this.languagesWithEnabledStates.containsValue(Boolean.TRUE);
    }
}

