/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.lingo.internal.project;

import com.atlassian.servicedesk.internal.api.lingo.project.LingoProjectConfiguration;
import com.atlassian.servicedesk.internal.api.lingo.project.LingoProjectLanguage;
import com.google.common.base.MoreObjects;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;

class LingoProjectConfigurationImpl
implements LingoProjectConfiguration {
    private final long projectId;
    private final Locale projectDefaultLocale;
    private final Set<LingoProjectLanguage> languages;

    LingoProjectConfigurationImpl(long projectId, Locale projectDefaultLocale, Set<LingoProjectLanguage> languages) {
        this.projectId = projectId;
        this.projectDefaultLocale = projectDefaultLocale;
        this.languages = languages;
    }

    public long getProjectId() {
        return this.projectId;
    }

    @Nonnull
    public Locale getProjectDefaultLocale() {
        return this.projectDefaultLocale;
    }

    @Nonnull
    public Set<LingoProjectLanguage> getLanguages() {
        return this.languages;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LingoProjectConfigurationImpl that = (LingoProjectConfigurationImpl)o;
        return this.projectId == that.projectId && Objects.equals(this.projectDefaultLocale, that.projectDefaultLocale) && Objects.equals(this.languages, that.languages);
    }

    public int hashCode() {
        return Objects.hash(this.projectId, this.projectDefaultLocale, this.languages);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("projectId", this.projectId).add("projectDefaultLocale", (Object)this.projectDefaultLocale).add("languages", this.languages).toString();
    }
}

