/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.lingo.internal.manager;

import com.atlassian.jira.config.LocaleManager;
import com.atlassian.servicedesk.internal.api.lingo.project.LingoProjectLanguage;
import com.atlassian.servicedesk.internal.api.lingo.response.Lingo;
import com.atlassian.servicedesk.internal.api.lingo.response.LingoTranslation;
import com.atlassian.servicedesk.plugins.lingo.internal.project.LingoProjectLanguageImpl;
import com.atlassian.servicedesk.plugins.lingo.internal.response.LingoImpl;
import com.atlassian.servicedesk.plugins.lingo.internal.response.LingoTranslationImpl;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class LingoPortugueseLocaleCompatibilityManager {
    private static final Locale PT_PT_LOCALE = new Locale("pt", "PT");
    private static final Locale PT_BR_LOCALE = new Locale("pt", "BR");
    private final LocaleManager localeManager;

    @Autowired
    public LingoPortugueseLocaleCompatibilityManager(LocaleManager localeManager) {
        this.localeManager = localeManager;
    }

    public Lingo applyTransformation(Lingo lingo, Set<Locale> availableLocales) {
        if (this.isPortugueseTransformationNeeded(this.retrieveDefinedLocales(lingo), availableLocales)) {
            return this.buildTransformedLingo(lingo);
        }
        return lingo;
    }

    public Set<LingoProjectLanguage> applyTransformation(Set<LingoProjectLanguage> lingoProjectLanguageSet) {
        Set availableLocales = this.localeManager.getInstalledLocales();
        if (this.isPortugueseTransformationNeeded(this.retrieveDefinedLocales(lingoProjectLanguageSet), availableLocales)) {
            return this.buildTransformedProjectLanguages(lingoProjectLanguageSet);
        }
        return lingoProjectLanguageSet;
    }

    private boolean isPortugueseTransformationNeeded(Set<Locale> definedLocales, Set<Locale> availableLocales) {
        return this.hasSystemInstalledLanguagesBeenSwitchedToBrazilianPortuguese(availableLocales) && this.doesLingoContainTranslationForOnlyPortuguesePortuguese(definedLocales);
    }

    private Set<Locale> retrieveDefinedLocales(Lingo lingo) {
        return lingo.getTranslations().stream().map(LingoTranslation::getLocale).collect(Collectors.toSet());
    }

    private Set<Locale> retrieveDefinedLocales(Set<LingoProjectLanguage> lingoProjectLanguage) {
        return lingoProjectLanguage.stream().map(LingoProjectLanguage::getLocale).collect(Collectors.toSet());
    }

    private Lingo buildTransformedLingo(Lingo lingo) {
        List<LingoTranslation> translations = lingo.getTranslations().stream().map(this::transformPortugueseTranslation).collect(Collectors.toList());
        return LingoImpl.withTranslations(lingo, translations);
    }

    private Set<LingoProjectLanguage> buildTransformedProjectLanguages(Set<LingoProjectLanguage> lingoProjectLanguageSet) {
        return lingoProjectLanguageSet.stream().map(this::transformPortugueseTranslation).collect(Collectors.toSet());
    }

    private LingoTranslation transformPortugueseTranslation(LingoTranslation translation) {
        if (translation.getLocale().equals(PT_PT_LOCALE)) {
            return new LingoTranslationImpl(translation.getLanguage(), PT_BR_LOCALE, translation.getContent(), translation.isEnabledTranslation(), translation.isSystemDefaultTranslation());
        }
        return translation;
    }

    private LingoProjectLanguage transformPortugueseTranslation(LingoProjectLanguage lingoProjectLanguage) {
        if (lingoProjectLanguage.getLocale().equals(PT_PT_LOCALE)) {
            return new LingoProjectLanguageImpl(PT_BR_LOCALE, lingoProjectLanguage.isActive());
        }
        return lingoProjectLanguage;
    }

    private boolean hasSystemInstalledLanguagesBeenSwitchedToBrazilianPortuguese(Set<Locale> availableLocales) {
        return !availableLocales.contains(PT_PT_LOCALE) && availableLocales.contains(PT_BR_LOCALE);
    }

    private boolean doesLingoContainTranslationForOnlyPortuguesePortuguese(Set<Locale> definedLocales) {
        return definedLocales.contains(PT_PT_LOCALE) && !definedLocales.contains(PT_BR_LOCALE);
    }
}

