/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.lingo.internal.languageresolution;

import com.atlassian.jira.config.LocaleManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.servicedesk.internal.api.lingo.languageresolution.LingoLanguageResolutionManager;
import com.atlassian.servicedesk.internal.api.lingo.project.LingoProjectLanguageManager;
import com.atlassian.servicedesk.internal.api.lingo.response.Lingo;
import com.atlassian.servicedesk.internal.api.lingo.response.LingoTranslation;
import com.atlassian.servicedesk.plugins.lingo.internal.response.LingoTranslationImpl;
import com.atlassian.servicedesk.plugins.lingo.internal.util.LingoUtil;
import com.google.common.base.Preconditions;
import io.atlassian.fugue.Option;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@ExportAsService
class LingoLanguageResolutionManagerImpl
implements LingoLanguageResolutionManager {
    private final LocaleManager localeManager;
    private final LingoProjectLanguageManager lingoProjectLanguageManager;

    @Autowired
    public LingoLanguageResolutionManagerImpl(LocaleManager localeManager, LingoProjectLanguageManager lingoProjectLanguageManager) {
        this.localeManager = localeManager;
        this.lingoProjectLanguageManager = lingoProjectLanguageManager;
    }

    public Option<LingoTranslation> resolveTranslationForLocaleFromMap(@Nonnull Map<Locale, String> translations, Locale locale, Option<Long> projectId) {
        Preconditions.checkArgument((!translations.isEmpty() ? 1 : 0) != 0, (Object)"Translations map cannot be empty");
        Locale defaultLocale = this.retrieveDefaultLocale(projectId);
        return this.internalResolveTranslationForLocale(this.localeMapToLingoTranslation(translations, projectId), locale, defaultLocale);
    }

    public Option<LingoTranslation> resolveTranslationForLocaleFromSupplierMap(@Nonnull Map<Locale, Supplier<String>> translations, Locale locale, Option<Long> projectId) {
        Preconditions.checkArgument((!translations.isEmpty() ? 1 : 0) != 0, (Object)"Translations map cannot be empty");
        Locale defaultLocale = this.retrieveDefaultLocale(projectId);
        return this.internalResolveTranslationForLocale(this.localeSupplierMapToLingoTranslation(translations, projectId), locale, defaultLocale);
    }

    public Option<LingoTranslation> resolveTranslationForUser(@Nonnull Lingo lingo, @Nullable ApplicationUser nullableUser) {
        Locale defaultLocale = this.retrieveDefaultLocale((Option<Long>)lingo.getProjectId());
        return this.resolveTranslationForNullableUser(lingo.getTranslations(), nullableUser, defaultLocale);
    }

    public Option<LingoTranslation> resolveTranslationForUserFromMap(@Nonnull Map<Locale, String> translations, @Nullable ApplicationUser nullableUser, Option<Long> projectId) {
        Preconditions.checkArgument((!translations.isEmpty() ? 1 : 0) != 0, (Object)"Translations map cannot be empty");
        List<LingoTranslation> lingoTranslations = this.localeMapToLingoTranslation(translations, projectId);
        Locale defaultLocale = this.retrieveDefaultLocale(projectId);
        return this.resolveTranslationForNullableUser(lingoTranslations, nullableUser, defaultLocale);
    }

    public Option<LingoTranslation> resolveTranslationForLocale(@Nonnull Lingo lingo, @Nonnull Locale locale) {
        Locale defaultLocale = this.retrieveDefaultLocale((Option<Long>)lingo.getProjectId());
        return this.internalResolveTranslationForLocale(lingo.getTranslations(), locale, defaultLocale);
    }

    public Option<LingoTranslation> resolveTranslationForUserFromSupplierMap(@Nonnull Map<Locale, Supplier<String>> translations, @Nullable ApplicationUser nullableUser, Option<Long> projectId) {
        Preconditions.checkArgument((!translations.isEmpty() ? 1 : 0) != 0, (Object)"Translations map cannot be empty");
        Locale defaultLocale = this.retrieveDefaultLocale(projectId);
        List<LingoTranslation> lingoTranslations = this.localeSupplierMapToLingoTranslation(translations, projectId);
        return this.resolveTranslationForNullableUser(lingoTranslations, nullableUser, defaultLocale);
    }

    public Option<LingoTranslation> resolveDefaultTranslation(@Nonnull Lingo lingo) {
        Locale defaultLocale = this.retrieveDefaultLocale((Option<Long>)lingo.getProjectId());
        return this.resolveDefaultTranslation(lingo.getTranslations(), defaultLocale);
    }

    public boolean isDefaultTranslation(@Nonnull LingoTranslation lingoTranslation, Option<Long> projectId) {
        Locale defaultLocale = this.retrieveDefaultLocale(projectId);
        return Objects.equals(lingoTranslation.getLocale(), defaultLocale);
    }

    private Option<LingoTranslation> resolveTranslationForNullableUser(Collection<LingoTranslation> lingoTranslations, ApplicationUser applicationUser, Locale defaultLocale) {
        return (Option)Option.option((Object)applicationUser).fold(() -> this.resolveDefaultTranslation(lingoTranslations, defaultLocale), user -> this.internalResolveTranslationForLocale(lingoTranslations, this.localeManager.getLocaleFor(user), defaultLocale));
    }

    private Option<LingoTranslation> resolveDefaultTranslation(Collection<LingoTranslation> lingoTranslations, Locale defaultLocale) {
        return this.internalResolveTranslationForLocale(lingoTranslations, defaultLocale, defaultLocale);
    }

    private Option<LingoTranslation> internalResolveTranslationForLocale(Collection<LingoTranslation> lingoTranslations, Locale locale, Locale defaultLocale) {
        Option<LingoTranslation> matchedTranslation = this.retrieveTranslationWithSameLocale(lingoTranslations, locale);
        return matchedTranslation.orElse(() -> this.retrieveTranslationWithSameLanguage(lingoTranslations, locale.getLanguage())).orElse(() -> this.retrieveTranslationForDefaultLocaleOrFirstInCollection(lingoTranslations, locale, defaultLocale));
    }

    private Option<? extends LingoTranslation> retrieveTranslationForDefaultLocaleOrFirstInCollection(Collection<LingoTranslation> lingoTranslations, Locale locale, Locale defaultLocale) {
        if (locale.equals(defaultLocale)) {
            return this.retrieveTranslationWithFirstOutOfSortedLanguageTags(lingoTranslations);
        }
        return this.internalResolveTranslationForLocale(lingoTranslations, defaultLocale, defaultLocale);
    }

    private Option<LingoTranslation> retrieveTranslationWithSameLocale(Collection<LingoTranslation> lingoTranslations, Locale locale) {
        return Option.fromOptional(this.sortedActiveTranslationStream(lingoTranslations).filter(translation -> locale.equals(translation.getLocale())).findFirst());
    }

    private Option<LingoTranslation> retrieveTranslationWithSameLanguage(Collection<LingoTranslation> lingoTranslations, String language) {
        return Option.fromOptional(this.sortedActiveTranslationStream(lingoTranslations).filter(translation -> Objects.equals(language, translation.getLanguage())).findFirst());
    }

    private Option<LingoTranslation> retrieveTranslationWithFirstOutOfSortedLanguageTags(Collection<LingoTranslation> lingoTranslations) {
        return Option.fromOptional(this.sortedActiveTranslationStream(lingoTranslations).findFirst());
    }

    private Stream<LingoTranslation> sortedActiveTranslationStream(Collection<LingoTranslation> lingoTranslations) {
        return lingoTranslations.stream().filter(LingoTranslation::isEnabledTranslation).sorted(LingoUtil.DEFAULT_TRANSLATION_COMPARATOR);
    }

    private Locale retrieveDefaultLocale(Option<Long> projectId) {
        return this.lingoProjectLanguageManager.retrieveDefaultLocale(projectId);
    }

    private List<LingoTranslation> localeMapToLingoTranslation(Map<Locale, String> translations, Option<Long> projectId) {
        return translations.entrySet().stream().map(entry -> new LingoTranslationImpl(((Locale)entry.getKey()).getLanguage(), (Locale)entry.getKey(), (String)entry.getValue(), this.lingoProjectLanguageManager.isEnabled((Locale)entry.getKey(), projectId), false)).collect(Collectors.toList());
    }

    private List<LingoTranslation> localeSupplierMapToLingoTranslation(Map<Locale, Supplier<String>> translations, Option<Long> projectId) {
        return translations.entrySet().stream().map(entry -> new LingoTranslationImpl(((Locale)entry.getKey()).getLanguage(), (Locale)entry.getKey(), (String)((Supplier)entry.getValue()).get(), this.lingoProjectLanguageManager.isEnabled((Locale)entry.getKey(), projectId), false)).collect(Collectors.toList());
    }
}

