/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.lingo.internal.dao.schema.ao;

import javax.annotation.Nullable;
import net.java.ao.OneToMany;
import net.java.ao.Preload;
import net.java.ao.RawEntity;
import net.java.ao.schema.AutoIncrement;
import net.java.ao.schema.Indexed;
import net.java.ao.schema.NotNull;
import net.java.ao.schema.PrimaryKey;
import net.java.ao.schema.StringLength;
import net.java.ao.schema.Table;

public class LingoDbSchema {

    @Preload
    @Table(value="PROJECT_LANGUAGE")
    public static interface ProjectLanguageAO
    extends RawEntity<Long> {
        @AutoIncrement
        @NotNull
        @PrimaryKey(value="ID")
        public long getID();

        @Nullable
        public Boolean getActive();

        @Nullable
        @StringLength(value=63)
        public String getLocale();

        @Nullable
        @Indexed
        public ProjectLangRevisionAO getProjectLangRev();
    }

    @Preload
    @Table(value="PROJECT_LANG_REV")
    public static interface ProjectLangRevisionAO
    extends RawEntity<Long> {
        @AutoIncrement
        @NotNull
        @PrimaryKey(value="ID")
        public long getID();

        @Nullable
        @StringLength(value=255)
        public String getAuthorUserKey();

        @Nullable
        public Long getCreatedTimestamp();

        @Nullable
        @StringLength(value=63)
        public String getDefaultLanguage();

        @Nullable
        @Indexed
        public ProjectLangConfigAO getProjectLangConfig();

        @OneToMany
        public ProjectLanguageAO[] getProjectLanguages();
    }

    @Preload
    @Table(value="PROJECT_LANG_CONFIG")
    public static interface ProjectLangConfigAO
    extends RawEntity<Long> {
        @AutoIncrement
        @NotNull
        @PrimaryKey(value="ID")
        public long getID();

        @Nullable
        public Long getCreatedTimestamp();

        @Nullable
        @Indexed
        public Long getProjectId();

        @OneToMany
        public ProjectLangRevisionAO[] getProjectLangRevisions();
    }

    @Preload
    @Table(value="LINGO_TRANSLATION")
    public static interface LingoTranslationAO
    extends RawEntity<Long> {
        @AutoIncrement
        @NotNull
        @PrimaryKey(value="ID")
        public long getID();

        @NotNull
        @StringLength(value=-1)
        public String getContent();

        @NotNull
        public Long getCreatedTimestamp();

        @NotNull
        @StringLength(value=63)
        public String getLanguage();

        @NotNull
        @StringLength(value=63)
        public String getLocale();

        @Nullable
        @Indexed
        public LingoRevisionAO getLingoRevision();
    }

    @Preload
    @Table(value="LINGO_REVISION")
    public static interface LingoRevisionAO
    extends RawEntity<Long> {
        @AutoIncrement
        @NotNull
        @PrimaryKey(value="ID")
        public long getID();

        @NotNull
        public Long getCreatedTimestamp();

        @Nullable
        @Indexed
        public LingoAO getLingo();

        @OneToMany
        public LingoTranslationAO[] getLingoTranslations();
    }

    @Preload
    @Table(value="LINGO")
    public static interface LingoAO
    extends RawEntity<Long> {
        @AutoIncrement
        @NotNull
        @PrimaryKey(value="ID")
        public long getID();

        @Nullable
        @StringLength(value=255)
        public String getCategory();

        @NotNull
        public Long getCreatedTimestamp();

        @Nullable
        @Indexed
        @StringLength(value=255)
        public String getLogicalId();

        @Nullable
        @Indexed
        public Long getProjectId();

        @Nullable
        @StringLength(value=255)
        public String getSystemI18n();

        @OneToMany
        public LingoRevisionAO[] getLingoRevisions();
    }
}

