/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.kb.internal.webpanel;

import com.atlassian.jira.util.I18nHelper;
import com.atlassian.plugin.web.model.WebPanel;
import com.atlassian.servicedesk.internal.api.util.SoyTemplateRenderer;
import com.atlassian.servicedesk.plugins.kb.internal.bootstrap.PluginInfo;
import com.atlassian.servicedesk.plugins.kb.internal.webpanel.KBWebPanelHelper;
import com.atlassian.soy.renderer.SoyException;
import io.atlassian.fugue.Either;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class KBDataWebPanel
implements WebPanel {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private final SoyTemplateRenderer soyTemplateRenderer;
    private final I18nHelper i18nHelper;
    private final KBWebPanelHelper kbWebPanelHelper;
    private String templateResourceModuleKey;

    @Autowired
    public KBDataWebPanel(SoyTemplateRenderer soyTemplateRenderer, I18nHelper i18nHelper, PluginInfo pluginInfo, KBWebPanelHelper kbWebPanelHelper) {
        this.soyTemplateRenderer = soyTemplateRenderer;
        this.i18nHelper = i18nHelper;
        this.kbWebPanelHelper = kbWebPanelHelper;
        this.templateResourceModuleKey = String.format("%s:%s", "com.atlassian.servicedesk.servicedesk-knowledge-base-plugin", "soy");
    }

    public String getHtml(Map<String, Object> context) {
        Either<String, Map<String, Object>> kbPanelParamsEither = this.kbWebPanelHelper.getKBPanelParams(context);
        return (String)kbPanelParamsEither.fold(error -> {
            this.logger.error("Encountered an error rendering the KB data panel: {}", error);
            return error;
        }, this::renderWebPanel);
    }

    public void writeHtml(Writer writer, Map<String, Object> map) throws IOException {
        writer.write(this.getHtml(map));
    }

    private String renderWebPanel(Map<String, Object> params) {
        String renderedContent;
        try {
            renderedContent = this.soyTemplateRenderer.render(this.templateResourceModuleKey, "ServiceDesk.Internal.KB.Feature.WebPanel.Templates.dataPanelContent", params);
        }
        catch (SoyException e) {
            String errorMessage = this.i18nHelper.getText("sd.knowledge.base.agent.issueview.panel.render.error.generic");
            this.logger.error(errorMessage, (Throwable)e);
            renderedContent = errorMessage;
        }
        return renderedContent;
    }
}

